<?php

namespace App\Http\Controllers;

use App\Models\Apishowroom;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Http;

class CentralReturnCheckController extends Controller
{
    public function index(Request $request)
    {
        $year = $request->input('year', Carbon::now()->year);
        $month = $request->input('month', Carbon::now()->month);

        // Get unique years from Showroom data (or use current year as fallback)
        $years = collect([Carbon::now()->year]); // Placeholder, can be enhanced to fetch from Showrooms
        $showrooms = Apishowroom::where('is_active', true)->get();
        $allReports = [];
        $errors = [];

        foreach ($showrooms as $showroom) {
            $response = Http::withToken($showroom->api_token)->get($showroom->api_url . '/return-report', [
                'year' => $year,
                'month' => $month,
            ]);

            if ($response->successful()) {
                $reportData = $response->json();
                $allReports[] = [
                    'showroom_name' => $showroom->name,
                    'showroom_identifier' => $showroom->identifier,
                    'year' => $reportData['year'],
                    'month' => $reportData['month'],
                    'report_data' => $reportData['report_data'],
                ];

                // Update last_pulled_at
                $showroom->update(['last_pulled_at' => Carbon::now()]);
            } else {
                $errors[] = "Failed to fetch return report from {$showroom->name} ({$showroom->identifier}).";
            }
        }

        return view('reports.returnreport', [
            'years' => $years,
            'selectedYear' => $year,
            'selectedMonth' => $month,
            'allReports' => $allReports,
            'errors' => $errors,
        ]);
    }


}