<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Aud;

class AuditReport extends Component
{
    public ?int $selectedShowroom = null;
    public ?int $selectedDate = null;
    public array $showrooms = [];
    public array $dates = [];
    public $auditData = null;

    public function mount()
    {
        // Fetch showroom names from the Aud table
        $this->showrooms = Aud::distinct()->pluck('srname', 'id')->toArray();
    }

    public function updatedSelectedShowroom()
    {
        $this->selectedDate = null;
        $this->auditData = null;

        if ($this->selectedShowroom) {
            $showroomName = Aud::where('id', $this->selectedShowroom)->value('srname');

            $this->dates = Aud::where('srname', $showroomName)
                ->pluck('date', 'id')
                ->toArray();
        } else {
            $this->dates = [];
        }
    }

    public function updatedSelectedDate()
    {
        if ($this->selectedDate) {
            $this->auditData = Aud::where('id', $this->selectedDate)->first();
        }
    }

    public function render()
    {
        return view('livewire.audit-report');
    }
}
