<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Apishowroom
 * 
 * @property int $id
 * @property string|null $name
 * @property string|null $identifier
 * @property string|null $api_url
 * @property string|null $api_token
 * @property bool|null $is_active
 * @property Carbon|null $last_pulled_at
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Apishowroom extends Model
{
	protected $table = 'apishowrooms';

	protected $casts = [
		'is_active' => 'bool',
		'last_pulled_at' => 'datetime'
	];

	protected $hidden = [
		'api_token'
	];

	protected $fillable = [
		'name',
		'identifier',
		'api_url',
		'api_token',
		'is_active',
		'last_pulled_at'
	];
}
