<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class CentralSaleItem
 * 
 * @property int $id
 * @property int $central_sale_report_id
 * @property string $product_name
 * @property string|null $product_category
 * @property string|null $production_department
 * @property string|null $barcode
 * @property string|null $sku
 * @property string|null $custom_no
 * @property int $quantity
 * @property float $unit_price
 * @property float|null $discount_amount
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class CentralSaleItem extends Model
{
	protected $table = 'central_sale_items';

	protected $casts = [
		'central_sale_report_id' => 'int',
		'quantity' => 'int',
		'unit_price' => 'float',
		'discount_amount' => 'float'
	];

	protected $fillable = [
		'central_sale_report_id',
		'product_name',
		'product_category',
		'production_department',
		'barcode',
		'sku',
		'custom_no',
		'quantity',
		'unit_price',
		'discount_amount'
	];

	    public function centralSalesReport()
    {
        return $this->belongsTo(CentralSalesReport::class, 'central_sale_report_id');
    }
}
