<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class DailyReport
 * 
 * @property int $id
 * @property Carbon $report_date
 * @property float $factory_bill
 * @property int|null $user_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class DailyReport extends Model
{
	protected $table = 'daily_reports';

	protected $casts = [
		'report_date' => 'datetime',
		'factory_bill' => 'float',
		'user_id' => 'int'
	];

	protected $fillable = [
		'report_date',
		'factory_bill',
		'user_id'
	];
}
