<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class DailyReturnReport
 * 
 * @property int $id
 * @property Carbon|null $report_date
 * @property float|null $fac_return_manual
 * @property int|null $return_100
 * @property int|null $return_50
 * @property int|null $damage
 * @property int|null $access_r
 * @property float|null $total_r
 * @property float|null $without_acc_t_return
 * @property float|null $diff
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class DailyReturnReport extends Model
{
	protected $table = 'daily_return_reports';

	protected $casts = [
		'report_date' => 'datetime',
		'fac_return_manual' => 'float',
		'return_100' => 'int',
		'return_50' => 'int',
		'damage' => 'int',
		'access_r' => 'int',
		'total_r' => 'float',
		'without_acc_t_return' => 'float',
		'diff' => 'float'
	];

	protected $fillable = [
		'report_date',
		'fac_return_manual',
		'return_100',
		'return_50',
		'damage',
		'access_r',
		'total_r',
		'without_acc_t_return',
		'diff'
	];
}
