<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Discount
 * 
 * @property int $id
 * @property string $name
 * @property string $type
 * @property float $value
 * @property Carbon|null $start_date
 * @property Carbon|null $end_date
 * @property bool|null $is_active
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class Discount extends Model
{
	protected $table = 'discounts';

	protected $casts = [
		'value' => 'float',
		'start_date' => 'datetime',
		'end_date' => 'datetime',
		'is_active' => 'bool'
	];

	protected $fillable = [
		'name',
		'type',
		'value',
		'start_date',
		'end_date',
		'is_active'
	];
}
