<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

/**
 * Class DiscountCampaign
 * 
 * @property int $id
 * @property int $discount_id
 * @property string $name
 * @property string|null $description
 * @property string $discount_type
 * @property int|null $category_id
 * @property array|null $product_ids
 * @property bool $is_active
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class DiscountCampaign extends Model
{
	protected $table = 'discount_campaigns';

	protected $casts = [
		'discount_id' => 'int',
		'product_ids' => 'json',
		'is_active' => 'bool'
	];

	protected $fillable = [
		'discount_id',
		'name',
		'description',
		'discount_type',
		'category_name',
		'product_ids',
		'is_active'
	];

	public function discount()
    {
        return $this->belongsTo(Discount::class);
    }


}
