<?php



namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProductPrice
 * 
 * @property int $id
 * @property int $product_id
 * @property float $price
 * @property Carbon $effective_start_date
 * @property Carbon|null $effective_end_date
 * @property int|null $changed_by_user_id
 * @property string|null $reason
 * @property bool|null $is_showroom_override
 * @property int|null $showroom_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class ProductPrice extends Model
{
	protected $table = 'product_prices';

	protected $casts = [
		'product_id' => 'int',
		'price' => 'float',
		'effective_start_date' => 'date',
		'effective_end_date' => 'date',
		'changed_by_user_id' => 'int',
		'is_showroom_override' => 'bool',
		'showroom_id' => 'int'
	];

	protected $fillable = [
		'product_id',
		'price',
		'effective_start_date',
		'effective_end_date',
		'changed_by_user_id',
		'reason',
		'is_showroom_override',
		'showroom_id'
	];

	/**
	 * Get the product that owns the price.
	 */
	public function product()
	{
		return $this->belongsTo(Product::class, 'product_id');	
	}

	/**
	 * Get the user who changed the price.
	 */
	public function changedByUser()
	{
		return $this->belongsTo(User::class, 'changed_by_user_id');
	}
	/**
	 * Get the showroom associated with this price, if it's a showroom override.
	 */
	public function showroom()
	{
		return $this->belongsTo(Showroom::class, 'showroom_id');
	}

}
