<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class ProductStock
 * 
 * @property int $id
 * @property int $product_id
 * @property Carbon $stock_date
 * @property int|null $opening_stock
 * @property int|null $received
 * @property int|null $return_damage
 * @property int|null $closing_stock
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class ProductStock extends Model
{
	protected $table = 'product_stocks';

	protected $casts = [
		'product_id' => 'int',
		'showroom_id' => 'int',
		'stock_date' => 'datetime',
		'opening_stock' => 'int',
		'received' => 'int',
		'return_damage' => 'int',
		'closing_stock' => 'int'
	];

	protected $fillable = [
		'product_id',
		'showroom_id',
		'stock_date',
		'opening_stock',
		'received',
		'return_damage',
		'closing_stock'
	];


	
    // Eloquent relationship to the product
    public function product()
    {
        return $this->belongsTo(Product::class);
    }
	// Eloquent relationship to the showroom
	public function showroom()
	{
		return $this->belongsTo(Showroom::class);
	}

}
