<?php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\Response;
use Illuminate\Auth\Access\HandlesAuthorization;

class UserPolicy
{
    /**
     * Determine whether the user can view any models.
     */

     public function viewAny(User $user): bool
     {
        return $user->hasRole('super_admin');
     }




    /**
     * Determine whether the user can view the model.
     */
    // public function view(User $user, User $model): bool
    // {
    //     return $user->isAdmin() || $user->id === $model->id; // Admins or users viewing themselves
    // }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->hasRole('super_admin');

    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, User $model): bool
    {
        return $user->hasRole('super_admin');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, User $model): bool
    {
        return $user->hasRole('super_admin');
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, User $model): bool
    {
        return false;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, User $model): bool
    {
        return false;
    }

    public function viewRoles(User $user): bool
    {
        return $user->hasRole('super_admin');
    }
    /**
     * Only allow Super Admin to assign roles.
     */
    public function assignRoles(User $user): bool
    {
        return $user->hasRole('super_admin');
    }

    /**
     * Only allow Super Admin to delete roles.
     */
    public function deleteRoles(User $user): bool
    {
        return $user->hasRole('super_admin');
    }
}
