@extends('layouts.main') 

@section('content')
<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Showroom API Tokens</h2>
        <a href="{{ route('generate_showroom_token') }}" class="btn btn-primary">Generate New Showroom Token</a>
    </div>

    @if ($showroomTokens->isEmpty())
        <div class="alert alert-info">
            No showroom API tokens found matching the criteria.
        </div>
    @else
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Token Name</th>
                        <th>Associated User (ID)</th> {{-- Shows the User ID the token belongs to --}}
                        <!-- <th>Token</th> -->
                        <th>Last Used</th>
                        <th>Created At</th>
                        <th>Expires At</th>
                        <th>Abilities</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($showroomTokens as $token)
                        <tr>
                            <td>{{ $token->id }}</td>
                            <td>{{ $token->name }}</td>
                            <td>{{ $token->tokenable_id }}</td>
                            <!-- <td>{{ $token->token }}</td>  -->
                            <td>{{ $token->last_used_at ? $token->last_used_at->diffForHumans() : 'Never' }}</td>
                            <td>{{ $token->created_at->format('Y-m-d H:i') }}</td>
                            <td>{{ $token->expires_at ? $token->expires_at->format('Y-m-d H:i') : 'Never' }}</td>
                            <td>
                                @if (!empty($token->abilities))
                                    @foreach (json_decode($token->abilities) as $ability)
                                        <span class="badge bg-info text-dark me-1">{{ $ability }}</span>
                                    @endforeach
                                @else
                                    <span class="badge bg-light text-muted">None</span>
                                @endif
                            </td>
                            <td>
                                {{-- Form for revoking a token --}}
                                {{-- Use JavaScript to handle this for better UX, but this is a basic example --}}
                                <form action="{{ route('admin.tokens.revoke-token', ['tokenId' => $token->id]) }}" method="POST" class="d-inline revoke-token-form">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger btn-sm">Revoke</button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-center">
            {{ $showroomTokens->links() }} {{-- Pagination links --}}
        </div>
    @endif
</div>


@push('scripts') 
<script>
    document.querySelectorAll('.revoke-token-form').forEach(form => {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            if (confirm('Are you sure you want to revoke this token? This action cannot be undone.')) {
                const form = this;
                fetch(form.action, {
                    method: 'POST', // Method will be overridden by _method DELETE
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json'
                    },
                    body: new FormData(form) // Send form data including _method
                })
                .then(response => {
                    if (!response.ok) {
                        return response.json().then(error => Promise.reject(error));
                    }
                    return response.json();
                })
                .then(data => {
                    alert(data.message || 'Token revoked successfully.');
                    location.reload(); // Reload the page to update the list
                })
                .catch(error => {
                    console.error('Error revoking token:', error);
                    alert(error.message || 'Failed to revoke token.');
                });
            }
        });
    });
</script>
@endpush
@endsection