@extends('layouts.guest') 

@section('content')
<div class="container"> 
    <div class="row justify-content-center">
        <div class="col-md-10 col-lg-8"> {{-- Adjusted columns for the card to be centered in guest layout --}}
            <div class="card shadow-sm rounded">
                <div class="card-body p-4">
                    <h5 class="card-title text-center mb-4 small text-uppercase">Login</h5>

                    @if (session('status'))
                        <div class="alert alert-success alert-dismissible fade show small" role="alert">
                            {{ session('status') }}
                            <button type="button" class="btn-close btn-sm" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('login') }}">
                        @csrf

                        <div class="mb-3">
                            <label for="email" class="form-label small">{{ __('Email') }}</label>
                            <input id="email" type="email" name="email" value="{{ old('email') }}" required autofocus autocomplete="username" class="form-control form-control-sm @error('email') is-invalid @enderror">
                            @error('email')
                                <div class="invalid-feedback d-block small">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="password" class="form-label small">{{ __('Password') }}</label>
                            <input id="password" type="password" name="password" required autocomplete="current-password" class="form-control form-control-sm @error('password') is-invalid @enderror">
                            @error('password')
                                <div class="invalid-feedback d-block small">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>



                        <div class="d-flex justify-content-between align-items-center mt-4">


                            <button type="submit" class="btn btn-primary btn-sm">
                                {{ __('Log in') }}
                            </button>
                        </div>
                    </form>

              
                </div>
            </div>
        </div>
    </div>
</div>
@endsection