@extends('layouts.main')

@section('content')
<div class="container-fluid mt-3">
    <div class="card card-sm">
        <div class="card-header bg-primary text-white py-2">
            <h5 class="mb-0">Edit Discount Campaign: {{ $discountCampaign->name }}</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('discount_campaigns.update', $discountCampaign->id) }}" method="POST">
                @csrf
                @method('PUT')

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-2">
                            <label for="name" class="form-label small">Campaign Name</label>
                            <input type="text" class="form-control form-control-sm @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $discountCampaign->name) }}" required>
                            @error('name')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-2">
                            <label for="discount_id" class="form-label small">Select Discount</label>
                            <select class="form-select form-select-sm select2 @error('discount_id') is-invalid @enderror" id="discount_id" name="discount_id" required>
                                <option value="">Select a Discount</option>
                                @foreach ($discounts as $discount)
                                    <option value="{{ $discount->id }}" {{ old('discount_id', $discountCampaign->discount_id) == $discount->id ? 'selected' : '' }}>
                                        {{ $discount->name }} ({{ $discount->value }}{{ $discount->type == 'percentage' ? '%' : '' }} {{ ucfirst($discount->type) }})
                                    </option>
                                @endforeach
                            </select>
                            @error('discount_id')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-2">
                            <label for="discount_type" class="form-label small">Campaign Target Type</label>
                            <select class="form-select form-select-sm @error('discount_type') is-invalid @enderror" id="discount_type" name="discount_type" required>
                                <option value="">Select Target Type</option>
                                <option value="global" {{ old('discount_type', $discountCampaign->discount_type) == 'global' ? 'selected' : '' }}>Global</option>
                                <option value="category" {{ old('discount_type', $discountCampaign->discount_type) == 'category' ? 'selected' : '' }}>Category Specific</option>
                                <option value="products" {{ old('discount_type', $discountCampaign->discount_type) == 'products' ? 'selected' : '' }}>Product Specific (Multiple)</option>
                            </select>
                            @error('discount_type')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6" id="category_select_container" style="display: {{ old('discount_type', $discountCampaign->discount_type) == 'category' ? 'block' : 'none' }};">
                        <div class="mb-2">
                            <label for="category_name" class="form-label small">Select Category</label>
                            {{-- Option 1: Select dropdown of existing product categories --}}
                            <select class="form-select form-select-sm select2 @error('category_name') is-invalid @enderror" id="category_name" name="category_name">
                                <option value="">Select Category</option>
                                @foreach ($categories as $category)
                                    <option value="{{ $category }}" {{ old('category_name', $discountCampaign->category_name) == $category ? 'selected' : '' }}>{{ $category }}</option>
                                @endforeach
                            </select>
                            {{-- Option 2: Text input for free-form category name (uncomment and remove Option 1 if preferred) --}}
                            {{-- <input type="text" class="form-control form-control-sm @error('category_name') is-invalid @enderror" id="category_name" name="category_name" value="{{ old('category_name', $discountCampaign->category_name) }}"> --}}
                            @error('category_name')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6" id="product_select_container" style="display: {{ old('discount_type', $discountCampaign->discount_type) == 'products' ? 'block' : 'none' }};">
                        <div class="mb-2">
                            <label for="product_ids" class="form-label small">Select Products</label>
                            <select class="form-select form-select-sm select2 @error('product_ids') is-invalid @enderror" id="product_ids" name="product_ids[]" multiple="multiple">
                                @foreach ($products as $product)
                                    <option value="{{ $product->id }}" {{ in_array($product->id, old('product_ids', $discountCampaign->product_ids ?? [])) ? 'selected' : '' }}>{{ $product->productname }} ({{ $product->productcategory }})</option>
                                @endforeach
                            </select>
                            @error('product_ids')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                            @error('product_ids.*')
                                <div class="invalid-feedback small">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="mb-2">
                    <label for="description" class="form-label small">Description</label>
                    <textarea class="form-control form-control-sm @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description', $discountCampaign->description) }}</textarea>
                    @error('description')
                        <div class="invalid-feedback small">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-check form-switch mb-3">
                    <input class="form-check-input form-check-input-sm" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $discountCampaign->is_active) ? 'checked' : '' }}>
                    <label class="form-check-label small" for="is_active">Is Active</label>
                </div>

                <button type="submit" class="btn btn-primary btn-sm">Update Campaign</button>
                <a href="{{ route('discount_campaigns.index') }}" class="btn btn-secondary btn-sm">Cancel</a>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Select2 for all select boxes
        $('.select2').select2({
            theme: 'bootstrap-5',
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: "Select an option",
            allowClear: true,
            containerCssClass: 'select2-container--small',
            selectionCssClass: 'select2-selection--small',
            dropdownCssClass: 'select2-dropdown--small',
        });

        const discountTypeSelect = document.getElementById('discount_type');
        const categorySelectContainer = document.getElementById('category_select_container');
        const productSelectContainer = document.getElementById('product_select_container');
        const categorySelect = document.getElementById('category_name');
        const productSelect = document.getElementById('product_ids');

        function toggleTargetFields() {
            const selectedType = discountTypeSelect.value;
            if (selectedType === 'category') {
                categorySelectContainer.style.display = 'block';
                productSelectContainer.style.display = 'none';
                // Do not clear product selection on edit unless discount type is explicitly changed
                // $(productSelect).val(null).trigger('change');
            } else if (selectedType === 'products') {
                productSelectContainer.style.display = 'block';
                categorySelectContainer.style.display = 'none';
                // Do not clear category selection on edit unless discount type is explicitly changed
                // $(categorySelect).val(null).trigger('change');
            } else { // global
                categorySelectContainer.style.display = 'none';
                productSelectContainer.style.display = 'none';
                // Do not clear selections on edit unless discount type is explicitly changed
                // $(categorySelect).val(null).trigger('change');
                // $(productSelect).val(null).trigger('change');
            }
        }

        // Initial call to set visibility based on current campaign data
        toggleTargetFields();

        // Add event listener for changes in discount type
        discountTypeSelect.addEventListener('change', toggleTargetFields);
    });
</script>
@endpush
