<div class="mb-2">
    <label for="name" class="form-label form-label-sm">Discount Name <span class="text-danger">*</span></label>
    <input type="text" class="form-control form-control-sm @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $discount->name ?? '') }}" required>
    @error('name')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="mb-2">
    <label for="type" class="form-label form-label-sm">Type <span class="text-danger">*</span></label>
    <select class="form-select form-select-sm @error('type') is-invalid @enderror select2" id="type" name="type" required data-placeholder="Select a type">
        <option value=""></option> {{-- Empty option for placeholder --}}
        @foreach($discountTypes as $type)
            <option value="{{ $type }}" @selected(old('type', $discount->type ?? '') == $type)>
                {{ ucwords(str_replace('_', ' ', $type)) }}
            </option>
        @endforeach
    </select>
    @error('type')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="mb-2">
    <label for="value" class="form-label form-label-sm">Value <span class="text-danger">*</span></label>
    <input type="number" step="0.01" class="form-control form-control-sm @error('value') is-invalid @enderror" id="value" name="value" value="{{ old('value', $discount->value ?? '') }}" required min="0">
    @error('value')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="mb-2">
    <label for="start_date" class="form-label form-label-sm">Start Date & Time <span class="text-danger">*</span></label>
    {{-- Format for datetime-local: YYYY-MM-DDTHH:MM --}}
    <input type="datetime-local" class="form-control form-control-sm @error('start_date') is-invalid @enderror" id="start_date" name="start_date" value="{{ old('start_date', isset($discount) ? $discount->start_date->format('Y-m-d\TH:i') : '') }}" required>
    @error('start_date')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="mb-2">
    <label for="end_date" class="form-label form-label-sm">End Date & Time <span class="text-danger">*</span></label>
    <input type="datetime-local" class="form-control form-control-sm @error('end_date') is-invalid @enderror" id="end_date" name="end_date" value="{{ old('end_date', isset($discount) ? $discount->end_date->format('Y-m-d\TH:i') : '') }}" required>
    @error('end_date')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

<div class="mb-2 form-check form-switch form-check-sm"> {{-- Small switch for checkbox --}}
    <input class="form-check-input @error('is_active') is-invalid @enderror" type="checkbox" id="is_active" name="is_active" value="1" @checked(old('is_active', $discount->is_active ?? true))>
    <label class="form-check-label form-label-sm" for="is_active">Is Active</label>
    @error('is_active')
        <div class="invalid-feedback">{{ $message }}</div>
    @enderror
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        // Initialize Select2 on the 'type' select box
        $('#type').select2({
            theme: 'bootstrap-5', // Apply Bootstrap 5 theme
            width: '100%', // Make it full width
            placeholder: $(this).data('placeholder'),
            allowClear: true, // Allow clearing the selection
        });
    });
</script>
@endpush