@extends('layouts.main')

@section('title', 'Edit Discount')

@section('content')
<div class="container-fluid mt-3">
    <div class="card card-sm">
        <div class="card-header py-2">
            <h5 class="mb-0">Edit Discount: {{ $discount->name }}</h5>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger alert-sm p-2">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('discounts.update', $discount->id) }}" method="POST">
                @csrf
                @method('PUT') {{-- Use PUT method for update --}}
                @include('discounts._form', ['discount' => $discount, 'discountTypes' => $discountTypes]) {{-- Pass discount and types data to partial --}}

                <div class="d-flex justify-content-end mt-3">
                    <button type="submit" class="btn btn-primary btn-sm me-2">Update Discount</button>
                    <a href="{{ route('discounts.index') }}" class="btn btn-secondary btn-sm">Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection