<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Main Layout')</title>
    <!-- Local Tailwind CSS -->
    <link rel="stylesheet" href="{{ asset('css/tailwind.css') }}">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="{{ asset('css/custom.css') }}">
    <!-- jQuery CDN -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        /* Custom styles for sidebar toggle */
        .sidebar {
            transition: transform 0.3s ease-in-out;
        }
        .sidebar-hidden {
            transform: translateX(-100%);
        }
    </style>
    @yield('styles')
</head>
<body class="flex flex-col h-screen bg-gray-100">
    <!-- Navbar -->
    @include('layouts.navbar')

    <div class="flex flex-1 overflow-hidden">
        <!-- Sidebar -->
        @include('layouts.sidebar')

        <!-- Main Content -->
        <main class="flex-1 p-6 overflow-y-auto">
            <div class="container mx-auto">
                @yield('content')
            </div>
        </main>
    </div>

    <!-- Footer -->

            @include('layouts.footer')


    <!-- Custom JavaScript -->
    <script src="{{ asset('js/custom.js') }}"></script>
    <script>
        $(document).ready(function() {
            // Mobile menu toggle
            $('#mobile-menu-button').click(function() {
                $('#mobile-menu').toggleClass('hidden');
                $('#sidebar').toggleClass('sidebar-hidden');
            });

            // Sidebar toggle for mobile
            $('#sidebar-toggle').click(function() {
                $('#sidebar').toggleClass('sidebar-hidden');
            });

            // Hide sidebar on mobile by default
            if ($(window).width() < 768) {
                $('#sidebar').addClass('sidebar-hidden');
            }
        });
    </script>
    @yield('scripts')
</body>
</html>