<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Main Layout')</title>

    {{-- CSRF Token --}}
    <meta name="csrf-token" content="{{ csrf_token() }}">

    {{-- Bootstrap CSS 5.1.3 (local) --}}
    <link href="{{ asset('dist/css/bootstrap.min.css') }}" rel="stylesheet">

    {{-- Font Awesome for icons (ensure this CDN version is compatible with your icons) --}}
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    {{-- Print.js CSS (CDN) --}}
    <link rel="stylesheet" href="{{ asset('css/print.min.css') }}">

    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

    
    {{-- Custom CSS (your project-specific styles, loaded last to override) --}}
    <link rel="stylesheet" href="{{ asset('css/custom.css') }}">

    @yield('styles') {{-- Page-specific styles --}}
</head>
<body class="d-flex flex-column min-vh-100 bg-light"> {{-- Using Bootstrap's flexbox and background utilities --}}

    {{-- Navbar --}}
    @include('layouts.navbar')

    {{-- Main Content Area --}}
    <main class="flex-grow-1 py-4"> {{-- flex-grow-1 makes it take available vertical space, py-4 for top/bottom padding --}}
        <div class="container-fluid"> {{-- Using Bootstrap's container for content width --}}
            @yield('content')
        </div>
    </main>

    {{-- Footer --}}
    @include('layouts.footer')


    {{-- jQuery CDN (load before Bootstrap's JS if Bootstrap components rely on it, though Bootstrap 5 is vanilla JS) --}}
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

    {{-- Bootstrap Bundle JS 5.1.3 (local - includes Popper.js) --}}
    <script src="{{ asset('dist/js/bootstrap.bundle.min.js') }}"></script>

    {{-- SheetJS JS (CDN) --}}
    <script src="https://unpkg.com/xlsx/dist/xlsx.full.min.js"></script>

    {{-- Print.js JS (CDN) --}}
    <script src="{{ asset('js/print.min.js') }}"></script>

    {{-- Select2 JS (CDN) --}}
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>




    {{-- Custom JavaScript (your project-specific scripts, loaded last) --}}
    <script src="{{ asset('js/custom.js') }}"></script>

    @stack('scripts') {{-- Page-specific scripts --}}
    
</body>
</html>