<nav class="navbar navbar-expand-lg navbar-light" style="background: linear-gradient(90deg, #74ebd5, #ACB6E5);">
    <div class="container-fluid">
        <a class="navbar-brand fw-bold text-white" href="{{ url('/') }}">
            {{ config('app.name', 'Laravel') }}
        </a>

        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMegaMenu" aria-controls="navbarMegaMenu" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarMegaMenu">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                {{-- Dashboard --}}
                <li class="nav-item">
                    <a class="nav-link text-white" href="{{ route('dashboard') }}">
                        Dashboard
                    </a>
                </li>

                {{-- Settings --}}
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Settings
                    </a>
                    <ul class="dropdown-menu shadow">
                        <li><a class="dropdown-item " href="{{ route('users.index') }}">Users</a></li>
                        <li><a class="dropdown-item " href="{{ route('profile.edit') }}">Profile</a></li>
                        <li><a class="dropdown-item " href="{{ route('roles.index') }}">Roles</a></li>
                        <li><a class="dropdown-item " href="{{ route('permissions.index') }}">Permissions</a></li>
                    </ul>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Showroom Management
                    </a>
                    <ul class="dropdown-menu shadow">
                        <li class="dropdown-submenu dropend">
                            <a class="dropdown-item dropdown-toggle " href="#">
                                Showrooms
                            </a>
                            <ul class="dropdown-menu shadow">
                                <li>
                                    <a class="dropdown-item " href="{{ route('sr.showroom.index') }}">
                                        All Showrooms
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item " href="{{ route('sr.showroom.create') }}">
                                        Add Showroom
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Inventory
                    </a>
                    <ul class="dropdown-menu shadow">
                        <li>
                            <a class="dropdown-item" href="{{ route('products.index') }}">Products</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link " href="{{ route('stocks.table') }}">Daily Stock</a>
                        </li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('product_prices.index') }}">Product Prices</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('discount_campaigns.index') }}">Discount Campaign</a></li>
                        <li class="nav-item"><a class="nav-link" href="{{ route('discounts.index') }}">Discount list</a></li>
                        <li class="nav-item"><a class="nav-link "    href="{{ route('reports.centralcheck.index') }}">Check Report - Bill Check</a></li>
                        <li class="nav-item"><a class="nav-link "    href="{{ route('rates.central-reports.index') }}">Check Report - Return Check</a></li>
                        
                        <li class="nav-item"><a class="nav-link "    href="{{route('reports.central-drinks.index')}}">Drinks Report</a></li>
                    </ul>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Sales
                    </a>
                    <ul class="dropdown-menu shadow">
                        <li>
                            <a class="dropdown-item" href="{{ route('apidmysales.create') }}">Received Sales Report</a>
                           
                        </li>
                    </ul>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Admin
                    </a>
                    <ul class="dropdown-menu shadow">
                        <li>
                            <a class="dropdown-item" href="{{ route('generate_showroom_token') }}">
                                Token
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link " href="{{ route('admin.sync.dashboard') }}">
                                sync dashboard
                            </a>
                        </li>
                    </ul>
                </li>

            </ul>

            {{-- Auth --}}
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                @guest
                    @if (Route::has('login'))
                        <li class="nav-item">
                            <a class="nav-link text-white" href="{{ route('login') }}">{{ __('Login') }}</a>
                        </li>
                    @endif
                    @if (Route::has('register'))
                        <li class="nav-item">
                            <a class="nav-link text-white" href="{{ route('register') }}">{{ __('Register') }}</a>
                        </li>
                    @endif
                @else
                    <li class="nav-item dropdown">
                        <a id="navbarDropdown" class="nav-link dropdown-toggle text-white" href="#" role="button" data-bs-toggle="dropdown">
                            {{ Auth::user()->name }}
                        </a>

                        <ul class="dropdown-menu dropdown-menu-end shadow">
                            <li>
                                <a class="dropdown-item" href="{{ route('logout') }}"
                                   onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                    {{ __('Logout') }}
                                </a>
                            </li>
                        </ul>

                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">@csrf</form>
                    </li>
                @endguest
            </ul>
        </div>
    </div>
</nav>
