@extends('layouts.main')

@section('content')
<div class="container-fluid py-2">
    <div class="d-flex justify-content-between align-items-center mb-2">
        <h4 class="mb-0">Create New Permission</h4>
        <a href="{{ route('permissions.index') }}" class="btn btn-secondary btn-sm">
            <i class="bi bi-arrow-left-circle me-1"></i> Back to List
        </a>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger alert-dismissible fade show py-2 px-3 small" role="alert">
            <ul class="mb-0 ps-3">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <div class="card card-sm">
        <div class="card-body py-3 px-3">
            <form action="{{ route('permissions.store') }}" method="POST">
                @csrf
                <div class="mb-2">
                    <label for="name" class="form-label small mb-1">Permission Name</label>
                    <input type="text" class="form-control form-control-sm" id="name" name="name" value="{{ old('name') }}" required>
                </div>
                <div class="mb-2">
                    <label for="guard_name" class="form-label small mb-1">Guard Name</label>
                    <input type="text" class="form-control form-control-sm" id="guard_name" name="guard_name" value="{{ old('guard_name', 'web') }}" required>
                    <div class="form-text small">Commonly 'web' or 'api'.</div>
                </div>
                <div class="mb-3">
                    <label for="roles" class="form-label small mb-1">Assign Roles</label>
                    <select class="form-select form-select-sm select2" id="roles" name="roles[]" multiple="multiple">
                        @foreach ($roles as $role)
                            <option value="{{ $role->id }}" {{ in_array($role->id, old('roles', [])) ? 'selected' : '' }}>
                                {{ $role->name }}
                            </option>
                        @endforeach
                    </select>
                    <div class="form-text small">Select roles to which this permission will be assigned.</div>
                </div>
                <button type="submit" class="btn btn-primary btn-sm">
                    <i class="bi bi-save me-1"></i> Save Permission
                </button>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/js/select2.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/css/select2.min.css" rel="stylesheet" />
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Select2 on all elements with class 'select2'
        $('.select2').select2({
            theme: 'bootstrap-5', // Use Bootstrap 5 theme for Select2
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: 'Select roles...',
            allowClear: true,
            dropdownParent: $('#roles').parent() // Ensures dropdown is correctly positioned
        });
    });
</script>
@endpush