@extends('layouts.main')

@section('content')
<div class="container-fluid py-3">
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">Generate API DMY Sales Report</h5>
        </div>
        <div class="card-body">
            <form action="{{ route('apidmysales.index') }}" method="GET">
                <div class="row g-2">
                    <div class="col-md-2">
                        <label class="form-label small">From Date</label>
                        <input type="date" name="from_date" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">To Date</label>
                        <input type="date" name="to_date" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">Showroom</label>
                        <select name="showroom_id" class="form-select form-select-sm select2">
                            <option value="all">All Showrooms</option>
                            @foreach($showrooms as $showroom)
                                <option value="{{ $showroom['id'] }}">{{ $showroom['name'] }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">Product Name</label>
                        <select name="productname" class="form-select form-select-sm select2">
                            <option value="">All Products</option>
                            @foreach($productNames as $name)
                                <option value="{{ $name }}">{{ $name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">Category</label>
                        <select name="productcategory" class="form-select form-select-sm select2">
                            <option value="">All Categories</option>
                            @foreach($productCategories as $category)
                                <option value="{{ $category }}">{{ $category }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">Department</label>
                        <select name="productiondepartment" class="form-select form-select-sm select2">
                            <option value="">All Departments</option>
                            @foreach($productionDepartments as $dept)
                                <option value="{{ $dept }}">{{ $dept }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">Barcode</label>
                        <input type="text" name="barcode" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">SKU</label>
                        <input type="text" name="sku" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-2">
                        <label class="form-label small">Custom No</label>
                        <input type="text" name="custom_no" class="form-control form-control-sm">
                    </div>
                    <div class="col-md-2">
                        <button type="submit" class="btn btn-primary btn-sm mt-4">Search</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
$(document).ready(function() {
    $('.select2').select2({
        placeholder: "Select an option",
        allowClear: true
    });
});
</script>
@endpush
@endsection