@extends('layouts.main') {{-- Assumes your main layout is at resources/views/layouts/main.blade.php --}}

@section('title', 'Profile')

@section('content')
<div class="container py-4"> {{-- Using Bootstrap's container and vertical padding --}}
    <div class="row justify-content-center"> {{-- Centering the content in the container --}}
        <div class="col-md-10 col-lg-8"> {{-- Responsive column widths for content areas --}}
            <div class="d-grid gap-4"> {{-- Bootstrap's grid gap for vertical spacing between sections --}}

                {{-- Profile Information Card --}}
                <div class="card shadow-sm">
                    <div class="card-body p-4 p-sm-5"> {{-- Bootstrap padding utilities, more on small screens --}}
                        <section>
                            <header class="mb-4">
                                <h2 class="h5 text-dark mb-1">
                                    {{ __('Profile Information') }}
                                </h2>
                                <p class="small text-muted">
                                    {{ __("Update your account's profile information and email address.") }}
                                </p>
                            </header>

                            <form id="send-verification" method="post" action="{{ route('verification.send') }}"></form>

                            <form method="post" action="{{ route('profile.update') }}" class="mt-4">
                                @csrf
                                @method('patch')

                                <div class="mb-3">
                                    <label for="name" class="form-label small">{{ __('Name') }}</label>
                                    <input id="name" name="name" type="text" class="form-control form-control-sm @error('name') is-invalid @enderror" value="{{ old('name', $user->name) }}" required autofocus autocomplete="name">
                                    @error('name')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="email" class="form-label small">{{ __('Email') }}</label>
                                    <input id="email" name="email" type="email" class="form-control form-control-sm @error('email') is-invalid @enderror" value="{{ old('email', $user->email) }}" required autocomplete="username">
                                    @error('email')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror

                                    @if ($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail())
                                        <div class="mt-2">
                                            <p class="small text-dark mb-1">
                                                {{ __('Your email address is unverified.') }}
                                                <button form="send-verification" class="btn btn-link btn-sm p-0 align-baseline text-decoration-underline">{{ __('Click here to re-send the verification email.') }}</button>
                                            </p>

                                            @if (session('status') === 'verification-link-sent')
                                                <p
                                                    x-data="{ show: true }"
                                                    x-show="show"
                                                    x-transition
                                                    x-init="setTimeout(() => show = false, 2000)"
                                                    class="alert alert-success alert-dismissible fade show small py-1 px-2 mt-2" role="alert"
                                                >
                                                    {{ __('A new verification link has been sent to your email address.') }}
                                                    <button type="button" class="btn-close btn-sm" data-bs-dismiss="alert" aria-label="Close"></button>
                                                </p>
                                            @endif
                                        </div>
                                    @endif
                                </div>

                                <div class="d-flex align-items-center gap-2"> {{-- Using Bootstrap's flex utilities for buttons --}}
                                    <button type="submit" class="btn btn-primary btn-sm">{{ __('Save') }}</button>

                                    @if (session('status') === 'profile-updated')
                                        <p
                                            x-data="{ show: true }"
                                            x-show="show"
                                            x-transition
                                            x-init="setTimeout(() => show = false, 2000)"
                                            class="text-muted small mb-0"
                                        >{{ __('Saved.') }}</p>
                                    @endif
                                </div>
                            </form>
                        </section>
                    </div>
                </div>

                {{-- Update Password Card --}}
                <div class="card shadow-sm">
                    <div class="card-body p-4 p-sm-5">
                        <section>
                            <header class="mb-4">
                                <h2 class="h5 text-dark mb-1">
                                    {{ __('Update Password') }}
                                </h2>
                                <p class="small text-muted">
                                    {{ __('Ensure your account is using a long, random password to stay secure.') }}
                                </p>
                            </header>

                            <form method="post" action="{{ route('password.update') }}" class="mt-4">
                                @csrf
                                @method('put')

                                <div class="mb-3">
                                    <label for="update_password_current_password" class="form-label small">{{ __('Current Password') }}</label>
                                    <input id="update_password_current_password" name="current_password" type="password" class="form-control form-control-sm @error('current_password', 'updatePassword') is-invalid @enderror" autocomplete="current-password">
                                    @error('current_password', 'updatePassword')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="update_password_password" class="form-label small">{{ __('New Password') }}</label>
                                    <input id="update_password_password" name="password" type="password" class="form-control form-control-sm @error('password', 'updatePassword') is-invalid @enderror" autocomplete="new-password">
                                    @error('password', 'updatePassword')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="update_password_password_confirmation" class="form-label small">{{ __('Confirm Password') }}</label>
                                    <input id="update_password_password_confirmation" name="password_confirmation" type="password" class="form-control form-control-sm @error('password_confirmation', 'updatePassword') is-invalid @enderror" autocomplete="new-password">
                                    @error('password_confirmation', 'updatePassword')
                                        <div class="invalid-feedback small">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="d-flex align-items-center gap-2">
                                    <button type="submit" class="btn btn-primary btn-sm">{{ __('Save') }}</button>

                                    @if (session('status') === 'password-updated')
                                        <p
                                            x-data="{ show: true }"
                                            x-show="show"
                                            x-transition
                                            x-init="setTimeout(() => show = false, 2000)"
                                            class="text-muted small mb-0"
                                        >{{ __('Saved.') }}</p>
                                    @endif
                                </div>
                            </form>
                        </section>
                    </div>
                </div>

                {{-- Delete Account Card --}}
                <div class="card shadow-sm">
                    <div class="card-body p-4 p-sm-5">
                        <section>
                            <header class="mb-4">
                                <h2 class="h5 text-dark mb-1">
                                    {{ __('Delete Account') }}
                                </h2>
                                <p class="small text-muted">
                                    {{ __('Once your account is deleted, all of its resources and data will be permanently deleted. Before deleting your account, please download any data or information that you wish to retain.') }}
                                </p>
                            </header>

                            {{-- Button to trigger the delete modal --}}
                            <button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#confirmUserDeletionModal">
                                {{ __('Delete Account') }}
                            </button>

                            {{-- Delete Account Modal --}}
                            <div class="modal fade" id="confirmUserDeletionModal" tabindex="-1" aria-labelledby="confirmUserDeletionModalLabel" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered modal-sm"> {{-- Centered and small modal --}}
                                    <div class="modal-content">
                                        <form method="post" action="{{ route('profile.destroy') }}" class="p-3"> {{-- Reduced padding for a smaller modal --}}
                                            @csrf
                                            @method('delete')

                                            <div class="modal-header border-0 pb-0"> {{-- No border, no bottom padding --}}
                                                <h5 class="modal-title h6" id="confirmUserDeletionModalLabel">{{ __('Are you sure you want to delete your account?') }}</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>

                                            <div class="modal-body pt-0"> {{-- No top padding --}}
                                                <p class="small text-muted mb-3">
                                                    {{ __('Once your account is deleted, all of its resources and data will be permanently deleted. Please enter your password to confirm you would like to permanently delete your account.') }}
                                                </p>

                                                <div class="mb-3">
                                                    <label for="password" class="visually-hidden">{{ __('Password') }}</label> {{-- Visually hidden label for accessibility --}}
                                                    <input
                                                        id="password"
                                                        name="password"
                                                        type="password"
                                                        class="form-control form-control-sm @error('password', 'userDeletion') is-invalid @enderror"
                                                        placeholder="{{ __('Password') }}"
                                                    />
                                                    @error('password', 'userDeletion')
                                                        <div class="invalid-feedback small">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="modal-footer border-0 pt-0"> {{-- No border, no top padding --}}
                                                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                                                <button type="submit" class="btn btn-danger btn-sm ms-2">{{ __('Delete Account') }}</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>

                        </section>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
{{-- Script to automatically open the modal if there are user deletion errors --}}
@if ($errors->userDeletion->isNotEmpty())
<script>
    $(document).ready(function() {
        var confirmUserDeletionModal = new bootstrap.Modal(document.getElementById('confirmUserDeletionModal'));
        confirmUserDeletionModal.show();
    });
</script>
@endif
@endsection