@extends('layouts.main')

@section('content')
<div class="container py-3">
    <h5 class="mb-3">Central Drinks Reports</h5>

    @if (!empty($errors))
        <div class="alert alert-danger alert-sm">
            <ul class="mb-0">
                @foreach ($errors as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="GET" action="{{ route('reports.central-drinks.index') }}" class="mb-3">
        <div class="row g-2 align-items-center">
            <div class="col-auto">
                <select name="year" class="form-select form-select-sm select2">
                    @foreach ($years as $yr)
                        <option value="{{ $yr }}" {{ $selectedYear == $yr ? 'selected' : '' }}>{{ $yr }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-auto">
                <select name="month" class="form-select form-select-sm select2">
                    @for ($m = 1; $m <= 12; $m++)
                        <option value="{{ $m }}" {{ $selectedMonth == $m ? 'selected' : '' }}>
                            {{ \Carbon\Carbon::create()->month((int)$m)->format('F') }}
                        </option>
                    @endfor
                </select>
            </div>
            <div class="col-auto">
                <select name="showroom" class="form-select form-select-sm select2">
                    <option value="">All Showrooms</option>
                    @foreach (\App\Models\Apishowroom::where('is_active', true)->get() as $showroom)
                        <option value="{{ $showroom->identifier }}"
                            {{ request('showroom') == $showroom->identifier ? 'selected' : '' }}>
                            {{ $showroom->name }} ({{ $showroom->identifier }})
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-auto">
                <button type="submit" class="btn btn-primary btn-sm">Filter</button>
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-secondary btn-sm" id="print-report">Print</button>
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-success btn-sm" id="export-report">Export</button>
            </div>
        </div>
    </form>

    @foreach ($allReports as $index => $report)
        @if (!request('showroom') || request('showroom') == $report['showroom_identifier'])
            <div class="card mb-3">
                <div class="card-header small">
                    {{ $report['showroom_name'] }} ({{ $report['showroom_identifier'] }}) - {{ \Carbon\Carbon::create()->month((int)$report['month'])->format('F') }} {{ $report['year'] }}
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover table-sm table-drinks-{{ $index }}">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    @foreach ($report['product_headers'] as $header)
                                        <th>{{ $header['name'] }} ({{ $header['price'] }})</th>
                                    @endforeach
                                    <th>Daily Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if (!empty($report['report_data']))
                                    @foreach ($report['report_data'] as $data)
                                        <tr>
                                            <td>{{ $data['date'] }}</td>
                                            @foreach ($report['product_headers'] as $header)
                                                <td>{{ $data['items'][$header['id']] ?? 0 }}</td>
                                            @endforeach
                                            <td>{{ $data['dailyTotal'] }}</td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr><td colspan="{{ count($report['product_headers']) + 2 }}" class="text-center">No data available for the selected period.</td></tr>
                                @endif
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Total</th>
                                    @foreach ($report['product_headers'] as $header)
                                        <th>{{ $report['product_totals'][$header['id']] ?? 0 }}</th>
                                    @endforeach
                                    <th>{{ $report['grand_total'] }}</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        @endif
    @endforeach
</div>

<script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'bootstrap-5',
            width: '100%',
        });
    });

    document.getElementById('print-report').addEventListener('click', function() {
        printJS({
            printable: document.querySelectorAll('.table'),
            type: 'html',
            header: 'Central Drinks Reports - {{ $selectedYear }}-{{ $selectedMonth }}',
            css: ['https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css'],
        });
    });

    document.getElementById('export-report').addEventListener('click', function() {
        const wb = XLSX.utils.book_new();
        @foreach ($allReports as $index => $report)
            @if (!request('showroom') || request('showroom') == $report['showroom_identifier'])
                const ws = XLSX.utils.table_to_sheet(document.querySelector('.table-drinks-{{ $index }}'));
                XLSX.utils.book_append_sheet(wb, ws, '{{ $report['showroom_identifier'] }}');
            @endif
        @endforeach
        XLSX.writeFile(wb, 'Central_Drinks_Reports_{{ $selectedYear }}-{{ $selectedMonth }}.xlsx');
    });
</script>
@endsection