@extends('layouts.main')

@section('content')
<div class="container-fluid py-2">
    <h5 class="mb-3">Central Monthly Reports - {{ $selectedMonth }}</h5>

    @if (!empty($errors))
        <div class="alert alert-danger alert-sm">
            <ul class="mb-0">
                @foreach ($errors as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="GET" action="{{ route('reports.centralcheck.index') }}" class="mb-3">
        <div class="row g-2 align-items-center">
            <div class="col-auto">
                <select name="month" class="form-select form-select-sm select2">
                    @for ($i = 0; $i < 12; $i++)
                        <option value="{{ \Carbon\Carbon::now()->subMonths($i)->format('Y-m') }}"
                            {{ $selectedMonth == \Carbon\Carbon::now()->subMonths($i)->format('Y-m') ? 'selected' : '' }}>
                            {{ \Carbon\Carbon::now()->subMonths($i)->format('F Y') }}
                        </option>
                    @endfor
                </select>
            </div>
            <div class="col-auto">
                <select name="showroom" class="form-select form-select-sm select2">
                    <option value="">All Showrooms</option>
                    @foreach (\App\Models\Apishowroom::where('is_active', true)->get() as $showroom)
                        <option value="{{ $showroom->identifier }}"
                            {{ request('showroom') == $showroom->identifier ? 'selected' : '' }}>
                            {{ $showroom->name }} ({{ $showroom->identifier }})
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-auto">
                <button type="submit" class="btn btn-primary btn-sm">Filter</button>
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-secondary btn-sm" id="print-report">Print</button>
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-success btn-sm" id="export-report">Export</button>
            </div>
        </div>
    </form>

    @foreach ($allReports as $index => $report)
        @if (!request('showroom') || request('showroom') == $report['showroom_identifier'])
            <div class="card mb-3">
                <div class="card-header small">
                    {{ $report['showroom_name'] }} ({{ $report['showroom_identifier'] }})
                </div>
                <div class="card-body">
                    <div class="row">
                        {{-- Left Column: Main Report Table --}}
                        <div class="col-lg-8 col-md-12 mb-4">
                            <div class="card h-100">
                                <div class="card-header small">
                                    Monthly Summary
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped table-hover table-sm table-main-{{ $index }}">
                                            <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Receive</th>
                                                    <th>Factory Bill</th>
                                                    <th>Diff</th>
                                                    <th>Outside Products</th>
                                                    <th>Ingredients FG</th>
                                                    <th>Internal DOI</th>
                                                    <th>Diff After Deduction</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if (!empty($report['daily_data']))
                                                    @foreach ($report['daily_data'] as $data)
                                                        <tr>
                                                            <td>{{ $data['report_date'] }}</td>
                                                            <td>{{ number_format($data['receive'], 2) }}</td>
                                                            <td>{{ number_format($data['factory_bill'], 2) }}</td>
                                                            <td>{{ number_format($data['diff'], 2) }}</td>
                                                            <td>{{ number_format($data['total_outside_products'], 2) }}</td>
                                                            <td>{{ number_format($data['ingredients_fg'], 2) }}</td>
                                                            <td>{{ number_format($data['internal_ingredients_used_doi'], 2) }}</td>
                                                            <td>{{ number_format($data['diff_after_deducting_outside_products'], 2) }}</td>
                                                        </tr>
                                                    @endforeach
                                                @else
                                                    <tr><td colspan="8" class="text-center">No data available.</td></tr>
                                                @endif
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>Total</th>
                                                    <th>{{ number_format($report['monthly_totals']['receive'], 2) }}</th>
                                                    <th>{{ number_format($report['monthly_totals']['factory_bill'], 2) }}</th>
                                                    <th>{{ number_format($report['monthly_totals']['diff'], 2) }}</th>
                                                    <th>{{ number_format($report['monthly_totals']['total_outside_products'], 2) }}</th>
                                                    <th>{{ number_format($report['monthly_totals']['ingredients_fg'], 2) }}</th>
                                                    <th>{{ number_format($report['monthly_totals']['internal_ingredients_used_doi'], 2) }}</th>
                                                    <th>{{ number_format($report['monthly_totals']['diff_after_deducting_outside_products'], 2) }}</th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        {{-- Right Column: Daily Sales and Closing Stock --}}
                        <div class="col-lg-4 col-md-12 mb-4">
                            <div class="card h-100">
                                <div class="card-header small">
                                    Daily Sales & Closing Stock
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-sm table-sales-{{ $index }}">
                                            <thead>
                                                <tr class="table-info">
                                                    <th>Date</th>
                                                    <th>Total Sale</th>
                                                    <th>Total Closing Stock</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @if (!empty($report['daily_data']))
                                                    @foreach($report['daily_data'] as $data)
                                                        <tr>
                                                            <td>{{ $data['report_date'] }}</td>
                                                            <td>{{ number_format($data['total_sale'], 2) }}</td>
                                                            <td>{{ number_format($data['total_closing_stock'], 2) }}</td>
                                                        </tr>
                                                    @endforeach
                                                @else
                                                    <tr><td colspan="3" class="text-center">No data available for the selected month.</td></tr>
                                                @endif
                                            </tbody>
                                            <tfoot>
                                                <tr class="table-dark fw-bold">
                                                    <td>Monthly Total</td>
                                                    <td>{{ number_format($report['monthly_totals']['total_sale'], 2) }}</td>
                                                    <td>{{ number_format($report['monthly_totals']['total_closing_stock'], 2) }}</td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endif
    @endforeach
</div>

<script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'default',
            width: 'auto',
        });
    });

    document.getElementById('print-report').addEventListener('click', function() {
        printJS({
            printable: document.querySelectorAll('.table'),
            type: 'html',
            header: 'Central Monthly Reports - {{ $selectedMonth }}',
            css: ['https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css'],
        });
    });

    document.getElementById('export-report').addEventListener('click', function() {
        const wb = XLSX.utils.book_new();
        @foreach ($allReports as $index => $report)
            @if (!request('showroom') || request('showroom') == $report['showroom_identifier'])
                const wsMain = XLSX.utils.table_to_sheet(document.querySelector('.table-main-{{ $index }}'));
                XLSX.utils.book_append_sheet(wb, wsMain, '{{ $report['showroom_identifier'] }}_Main');
                const wsSales = XLSX.utils.table_to_sheet(document.querySelector('.table-sales-{{ $index }}'));
                XLSX.utils.book_append_sheet(wb, wsSales, '{{ $report['showroom_identifier'] }}_Sales');
            @endif
        @endforeach
        XLSX.writeFile(wb, 'Central_Monthly_Reports_{{ $selectedMonth }}.xlsx');
    });
</script>
@endsection