@extends('layouts.main')

@section('content')
<div class="container py-3">
    <h5 class="mb-3">Central Return Reports</h5>

    @if (!empty($errors))
        <div class="alert alert-danger alert-sm">
            <ul class="mb-0">
                @foreach ($errors as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form method="GET" action="{{ route('rates.central-reports.index') }}" class="mb-3">
        <div class="row g-2 align-items-center">
            <div class="col-auto">
                <select name="year" class="form-select form-select-sm select2">
                    @foreach ($years as $yr)
                        <option value="{{ $yr }}" {{ $selectedYear == $yr ? 'selected' : '' }}>{{ $yr }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-auto">
                <select name="month" class="form-select form-select-sm select2">
                    @for ($m = 1; $m <= 12; $m++)
                        <option value="{{ $m }}" {{ $selectedMonth == $m ? 'selected' : '' }}>
                            {{ \Carbon\Carbon::create()->month((int)$m)->format('F') }}
                        </option>
                    @endfor
                </select>
            </div>
            <div class="col-auto">
                <select name="showroom" class="form-select form-select-sm select2">
                    <option value="">All Showrooms</option>
                    @foreach (\App\Models\Apishowroom::where('is_active', true)->get() as $showroom)
                        <option value="{{ $showroom->identifier }}"
                            {{ request('showroom') == $showroom->identifier ? 'selected' : '' }}>
                            {{ $showroom->name }} ({{ $showroom->identifier }})
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-auto">
                <button type="submit" class="btn btn-primary btn-sm">Filter</button>
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-secondary btn-sm" id="print-report">Print</button>
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-success btn-sm" id="export-report">Export</button>
            </div>
        </div>
    </form>

    @foreach ($allReports as $index => $report)
        @if (!request('showroom') || request('showroom') == $report['showroom_identifier'])
            <div class="card mb-3">
                <div class="card-header small">
                    {{ $report['showroom_name'] }} ({{ $report['showroom_identifier'] }}) - {{ \Carbon\Carbon::create()->month((int)$report['month'])->format('F') }} {{ $report['year'] }}
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover table-sm table-return-{{ $index }}">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Fac Return (Calc)</th>
                                    <th>Fac Return (Manual)</th>
                                    <th>Return 100%</th>
                                    <th>Return 50%</th>
                                    <th>Damage</th>
                                    <th>Access R</th>
                                    <th>Total R</th>
                                    <th>Without Acc T Return</th>
                                    <th>Diff</th>
                                </tr>
                            </thead>
            <tbody>
                @if (!empty($report['report_data']))
                    @foreach ($report['report_data'] as $data)
                        <tr>
                            <td>{{ $data['date'] }}</td>
                            <td>{{ number_format($data['calculatedFacReturnFromStock'], 2) }}</td>
                            <td>{{ number_format($data['facReturnInput'], 2) }}</td>
                            <td>{{ $data['return100'] }}</td>
                            <td>{{ $data['return50'] }}</td>
                            <td>{{ $data['damage'] }}</td>
                            <td>{{ $data['accessR'] }}</td>
                            <td>{{ number_format($data['totalR'], 2) }}</td>
                            <td>{{ number_format($data['withoutAccTReturn'], 2) }}</td>
                            <td>{{ number_format($data['diff'], 2) }}</td>
                        </tr>
                    @endforeach
                @else
                    <tr><td colspan="10" class="text-center">No data available for the selected period.</td></tr>
                @endif
            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        @endif
    @endforeach
</div>

<script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'bootstrap-5',
            width: '100%',
        });
    });

    document.getElementById('print-report').addEventListener('click', function() {
        printJS({
            printable: document.querySelectorAll('.table'),
            type: 'html',
            header: 'Central Return Reports - {{ $selectedYear }}-{{ $selectedMonth }}',
            css: ['https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css'],
        });
    });

    document.getElementById('export-report').addEventListener('click', function() {
        const wb = XLSX.utils.book_new();
        @foreach ($allReports as $index => $report)
            @if (!request('showroom') || request('showroom') == $report['showroom_identifier'])
                const ws = XLSX.utils.table_to_sheet(document.querySelector('.table-return-{{ $index }}'));
                XLSX.utils.book_append_sheet(wb, ws, '{{ $report['showroom_identifier'] }}');
            @endif
        @endforeach
        XLSX.writeFile(wb, 'Central_Return_Reports_{{ $selectedYear }}-{{ $selectedMonth }}.xlsx');
    });
</script>
@endsection