@extends('layouts.main')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between mb-2">
        <h6 class="fw-bold">Showroom List</h6>
        <div>
            <a href="{{ route('sr.showroom.create') }}" class="btn btn-sm btn-primary">Add New</a>
            <button class="btn btn-sm btn-outline-secondary" onclick="printJS({ printable: 'report-table', type: 'html', css: 'bootstrap.css' })">Print</button>
            <button class="btn btn-sm btn-outline-success" onclick="exportToExcel()">Export</button>
        </div>
    </div>

    <form method="GET" class="row g-1 mb-2">
        <div class="col-auto">
            <input type="text" name="search" class="form-control form-control-sm" value="{{ request('search') }}" placeholder="Search...">
        </div>
        <div class="col-auto">
            <select name="status" class="form-select form-select-sm select2">
                <option value="">All Status</option>
                <option value="active" @selected(request('status') == 'active')>Active</option>
                <option value="inactive" @selected(request('status') == 'inactive')>Inactive</option>
            </select>
        </div>
        <div class="col-auto">
            <button type="submit" class="btn btn-sm btn-secondary">Filter</button>
        </div>
    </form>

    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover table-striped" id="report-table">
            <thead class="table-light text-center small">
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Code</th>
                    <th>City</th>
                    <th>Manager</th>
                    <th>Status</th>
                    <th class="text-nowrap">Actions</th>
                </tr>
            </thead>
            <tbody class="small">
                @foreach ($showrooms as $index => $sr)
                <tr>
                    <td>{{ $showrooms->firstItem() + $index }}</td>
                    <td>{{ $sr->name }}</td>
                    <td>{{ $sr->code }}</td>
                    <td>{{ $sr->city }}</td>
                    <td>{{ $sr->manager_name }}</td>
                    <td>
                        <span class="badge bg-{{ $sr->status === 'active' ? 'success' : 'secondary' }}">{{ ucfirst($sr->status) }}</span>
                    </td>
                    <td class="text-nowrap">
                        <a href="{{ route('sr.showroom.edit', $sr) }}" class="btn btn-sm btn-outline-primary">Edit</a>
                        <form action="{{ route('sr.showroom.destroy', $sr) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete showroom?');">
                            @csrf @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="mt-2 small">
            {{ $showrooms->withQueryString()->links('pagination::bootstrap-5') }}
        </div>
    </div>
</div>

<script>
    function exportToExcel() {
        const table = document.getElementById('report-table');
        const wb = XLSX.utils.table_to_book(table);
        XLSX.writeFile(wb, 'Showrooms.xlsx');
    }

    document.addEventListener('DOMContentLoaded', () => {
        $('.select2').select2({ width: 'resolve' });
    });
</script>
@endsection
