@extends('layouts.main')

@section('content')
<div class="container-fluid py-2">
    <div class="d-flex justify-content-between align-items-center mb-2">
        <h4 class="mb-0">Create New User</h4>
        <a href="{{ route('users.index') }}" class="btn btn-secondary btn-sm">
            <i class="bi bi-arrow-left-circle me-1"></i> Back to List
        </a>
    </div>

    @if ($errors->any())
    <div class="alert alert-danger alert-dismissible fade show py-2 px-3 small" role="alert">
        <ul class="mb-0 ps-3">
            @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
        <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
    @endif

    <div class="card card-sm">
        <div class="card-body py-3 px-3">
            <form action="{{ route('users.store') }}" method="POST">
                @csrf
                <div class="mb-2">
                    <label for="name" class="form-label small mb-1">Name</label>
                    <input type="text" class="form-control form-control-sm" id="name" name="name" value="{{ old('name') }}" required>
                </div>
                <div class="mb-2">
                    <label for="email" class="form-label small mb-1">Email</label>
                    <input type="email" class="form-control form-control-sm" id="email" name="email" value="{{ old('email') }}" required>
                </div>
                <div class="mb-2">
                    <label for="password" class="form-label small mb-1">Password</label>
                    <input type="password" class="form-control form-control-sm" id="password" name="password" required>
                </div>
                <div class="mb-2">
                    <label for="roles" class="form-label small mb-1">Assign Role</label>
                    <select class="form-select form-select-sm" id="roles" name="roles" required>
                        <option value="">Select a Role</option>
                        @foreach ($roles as $id => $name)
                        <option value="{{ $id }}" {{ old('roles') == $id ? 'selected' : '' }}>
                            {{ $name }}
                        </option>
                        @endforeach
                    </select>
                    <div class="form-text small">Select the primary role for this user.</div>
                </div>
                <div class="mb-3">
                    <label for="showroom_id" class="form-label small mb-1">Assign Showroom (Optional)</label>
                    <select class="form-select form-select-sm" id="showroom_id" name="showroom_id">
                        <option value="">No Showroom</option>
                        @foreach ($showrooms as $showroom)
                        <option value="{{ $showroom->id }}" {{ old('showroom_id') == $showroom->id ? 'selected' : '' }}>
                            {{ $showroom->name }}
                        </option>
                        @endforeach
                    </select>
                    <div class="form-text small">Assign a showroom to this user.</div>
                </div>
                <button type="submit" class="btn btn-primary btn-sm">
                    <i class="bi bi-save me-1"></i> Save User
                </button>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Select2 on all elements with class 'select2'
        $('.select2').select2({
            theme: 'bootstrap-5', // Use Bootstrap 5 theme for Select2
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: $(this).attr('placeholder') || 'Select an option...',
            allowClear: true,
            dropdownParent: $(this).parent() // Ensures dropdown is correctly positioned
        });
    });
</script>
@endpush