<?php
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use App\Http\Controllers\Admin\ShowroomApiTokenController;
use App\Http\Controllers\Api\ProductPriceApiController;
use App\Http\Controllers\Api\ProductSyncController;
use App\Http\Controllers\ReceiveSalesReportController;
use App\Http\Controllers\Api\DiscountApiController;
use App\Http\Controllers\Api\DiscountCampaignApiController;


Route::middleware([])->group(function () {
    // CHANGE THIS LINE: Remove 'api.' from the name() method
    Route::post('/admin/tokens/generate-showroom-token', [ShowroomApiTokenController::class, 'generateToken'])->name('admin.tokens.generate-showroom-token');
    // Expected Full Name: api.admin.tokens.generate-showroom-token

    // CHANGE THIS LINE for consistency:
    Route::delete('/admin/tokens/{tokenId}', [ShowroomApiTokenController::class, 'revokeToken'])->name('admin.tokens.revoke-token');
    // Expected Full Name: api.admin.tokens.revoke-token

    Route::post('/product-prices/sync-to-showroom', [ProductPriceApiController::class, 'syncPricesToShowroom'])->name('product_prices.sync_to_showroom');
    
    Route::post('/sync-products', [ProductSyncController::class, 'syncProductsToShowroom'])->name('sync.products');

    // API Resources for Discounts
Route::apiResource('discounts', DiscountApiController::class);

// API Resources for Discount Campaigns
Route::apiResource('discount_campaigns', DiscountCampaignApiController::class);

});
