<?php
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ShowroomController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\StockController;
use App\Http\Controllers\Admin\ShowroomApiTokenController;
use App\Http\Controllers\Admin\ShowroomManagementController;
use App\Http\Controllers\ProductPriceController;
use App\Http\Controllers\CentralCheckReportController;
use App\Http\Controllers\CentralReturnCheckController;
use App\Http\Controllers\CentralDrinksCheckController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\DmySalesController;
use App\Http\Controllers\ApiDmySalesController;
use App\Http\Controllers\DiscountCampaignController;
use App\Http\Controllers\DiscountController; // New Controller for Discount Management
use App\Http\Controllers\DiscountCampaignApiController; // New API Controller for Discounts



Route::get('/', function () {
    return redirect()->route('login');
    });

Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', function () {
        return view('dashboard');
    })->name('dashboard');

    Route::resource('users', UserController::class);
    Route::post('users/{id}/restore', [UserController::class, 'restore'])->name('users.restore');
    Route::delete('users/{id}/force', [UserController::class, 'forceDelete'])->name('users.forceDelete');
    Route::resource('showrooms', ShowroomController::class)->names('sr.showroom')->except(['show']);

    Route::resource('products', ProductController::class)->names('products')->except(['show']);

    Route::get('stocks', [StockController::class, 'index'])->name('stocks.index');
    Route::post('stocks', [StockController::class, 'update'])->name('stocks.update');
    Route::get('stocks/data', [StockController::class, 'fetchStockData'])->name('stocks.data');
    Route::get('stocks/table', [StockController::class, 'table'])->name('stocks.table');
    Route::get('/stocks/fetch', [StockController::class, 'fetch'])->name('stocks.fetch');
    Route::post('/stocks/update', [StockController::class, 'update'])->name('stocks.update');

    Route::middleware(['auth'])->group(function () {
        Route::get('/admin/tokens/generate', [ShowroomApiTokenController::class, 'showGenerateForm'])->name('generate_showroom_token');
        // You might also want a page to list/manage tokens
        Route::get('/admin/tokens', [ShowroomApiTokenController::class, 'listShowroomTokensView'])->name('admin.tokens.index');
    });

        Route::post('/sync-product-to-productprices', [ProductController::class, 'syncInternalProductToProductPrices'])
    ->name('products.syncPrices');

    Route::get('reports/central-drinks', [CentralDrinksCheckController::class,'index'])->name('reports.central-drinks.index');
    
    Route::get('reports/central', [CentralCheckReportController::class, 'index'])->name('reports.centralcheck.index');

    Route::get('rates/central-reports', [CentralReturnCheckController::class,'index'])->name('rates.central-reports.index');


    Route::resource('permissions', PermissionController::class)->except(['show']);
    Route::resource('roles', RoleController::class)->except(['show']);
    Route::resource('apidmysales', ApiDmySalesController::class)->only(['index', 'create', 'edit', 'update', 'destroy']);
    Route::get('/sales-reports', [DmySalesController::class, 'index'])->name('sales.reports.local');

    Route::resource('discount_campaigns', DiscountCampaignController::class)->except(['show']);
    Route::resource('discounts', DiscountController::class)->except(['show']);
    Route::post('/discount-sync', [DiscountCampaignApiController::class, 'syncDiscountData'])->name('syncDiscountData.showrooms');

});

Route::resource('product_prices', ProductPriceController::class)->except(['show']);


    if (env('APP_TYPE') === 'central') {
        Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
            // Showroom management dashboard
        Route::get('/sync-dashboard', [ShowroomManagementController::class, 'index'])->name('sync.dashboard');

        // CRUD for Showrooms (create/edit via this dashboard)
        Route::post('/showrooms', [ShowroomManagementController::class, 'store'])->name('showrooms.store');
        Route::put('/showrooms/{showroom}', [ShowroomManagementController::class, 'update'])->name('showrooms.update');
        Route::delete('/showrooms/{showroom}', [ShowroomManagementController::class, 'destroy'])->name('showrooms.destroy');

        // Actions for individual Showrooms
        Route::post('/showrooms/{showroom}/toggle-status', [ShowroomManagementController::class, 'toggleStatus'])->name('showrooms.toggle_status');
        Route::post('/showrooms/{showroom}/pull-stock', [ShowroomManagementController::class, 'pullSingleStock'])->name('showrooms.pull_stock');

        // Global pull action
        Route::post('/sync/pull-all-stock', [ShowroomManagementController::class, 'pullAllStock'])->name('sync.pull_all_stock');

        });
    }

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';
