

<?php $__env->startSection('title', 'Discounts List'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid mt-3">
    <div class="card card-sm">
        <div class="card-header py-2 d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Discounts</h5>
            <div>
                <a href="<?php echo e(route('discounts.create')); ?>" class="btn btn-success btn-sm me-2">Add New Discount</a>
                <button id="printReportBtn" class="btn btn-info btn-sm me-2">Print Report</button>
                <button id="exportDataBtn" class="btn btn-primary btn-sm">Export Data</button>
            </div>
        </div>
        <div class="card-body p-2">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-sm p-2 mb-2">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
            <?php if(session('error')): ?>
                <div class="alert alert-danger alert-sm p-2 mb-2">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover table-sm" id="discounts-table"> 
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Value</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Active</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $discounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $discount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($loop->iteration + ($discounts->currentPage() - 1) * $discounts->perPage()); ?></td>
                                <td><?php echo e($discount->name); ?></td>
                                <td><?php echo e(ucwords(str_replace('_', ' ', $discount->type))); ?></td>
                                <td><?php echo e($discount->value); ?><?php echo e($discount->type == 'percentage' ? '%' : ''); ?></td>
                                <td><?php echo e($discount->start_date->format('Y-m-d H:i')); ?></td>
                                <td><?php echo e($discount->end_date->format('Y-m-d H:i')); ?></td>
                                <td>
                                    <?php if($discount->is_active): ?>
                                        <span class="badge bg-success">Yes</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">No</span>
                                    <?php endif; ?>
                                </td>
                                <td class="d-flex">
                                    <a href="<?php echo e(route('discounts.edit', $discount->id)); ?>" class="btn btn-warning btn-sm me-1">Edit</a>
                                    <form action="<?php echo e(route('discounts.destroy', $discount->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this discount?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center">No discounts found.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-center">
                <?php echo e($discounts->links('pagination::bootstrap-5')); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    // Print.js integration
    document.getElementById('printReportBtn').addEventListener('click', function() {
        printJS({
            printable: 'discounts-table', // Use the ID of your table
            type: 'html',
            header: '<h2>Discount Report</h2>',
            css: 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css',
            style: `
                /* Custom styles for printing */
                table { width: 100%; border-collapse: collapse; }
                th, td { border: 1px solid #dee2e6; padding: 0.25rem; text-align: left; font-size: 0.75rem; }
                h2 { text-align: center; margin-bottom: 1rem; }
                /* Ensure text is black for printing */
                body, table, th, td { color: #000 !important; }
            `
        });
        console.log('Print report button clicked. (Requires print.js library)');
    });

    // Sheet.js integration for exporting
    document.getElementById('exportDataBtn').addEventListener('click', function() {
        const table = document.getElementById('discounts-table'); // Select the table by ID
        if (table) {
            const ws = XLSX.utils.table_to_sheet(table);
            const wb = XLSX.utils.book_new();
            XLSX.utils.book_append_sheet(wb, ws, "Discounts");
            XLSX.writeFile(wb, "discounts_data.xlsx");
            console.log('Export data button clicked. (Requires sheet.js library)');
        } else {
            console.error('Table not found for export.');
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DEVELOPMENT\laragon-6.0.0\www\00central\resources\views/discounts/index.blade.php ENDPATH**/ ?>