

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-2">
        <h5 class="mb-0 text-secondary">Product Prices</h5>
        <div>
            <a href="<?php echo e(route('product_prices.create')); ?>" class="btn btn-sm btn-primary">
                <i class="fas fa-plus"></i> New Price
            </a>
            <button class="btn btn-sm btn-info ms-1" onclick="printTable()">
                <i class="fas fa-print"></i> Print
            </button>
            <button class="btn btn-sm btn-success ms-1" onclick="exportTable()">
                <i class="fas fa-file-excel"></i> Export
            </button>
            
            <button class="btn btn-sm btn-warning ms-1" data-bs-toggle="modal" data-bs-target="#syncPricesModal">
                <i class="fas fa-paper-plane"></i> Push Prices to Showroom(s)
            </button>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show py-2" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    
    <?php if(session('sync_results')): ?>
        <div class="alert alert-info alert-dismissible fade show py-2" role="alert">
            <h6>Price Sync Results:</h6>
            <ul class="list-unstyled mb-0 small">
                <?php $__currentLoopData = session('sync_results'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($result); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    
    <div class="card card-body p-2 mb-2">
        <h6 class="mb-2 text-secondary small">Filter Prices</h6>
        <form method="GET" action="<?php echo e(route('product_prices.index')); ?>" class="row g-2 align-items-end">
            <div class="col-md-3 col-lg-2">
                <label for="product_name" class="form-label small mb-0">Product Name</label>
                <input type="text" class="form-control form-control-sm" id="product_name" name="product_name" value="<?php echo e(request('product_name')); ?>">
            </div>

            <div class="col-md-3 col-lg-2">
                <label for="price_min" class="form-label small mb-0">Price Min</label>
                <input type="number" step="0.01" class="form-control form-control-sm" id="price_min" name="price_min" value="<?php echo e(request('price_min')); ?>">
            </div>
            <div class="col-md-3 col-lg-2">
                <label for="price_max" class="form-label small mb-0">Price Max</label>
                <input type="number" step="0.01" class="form-control form-control-sm" id="price_max" name="price_max" value="<?php echo e(request('price_max')); ?>">
            </div>

            <div class="col-md-3 col-lg-2">
                <label for="start_date_from" class="form-label small mb-0">Start Date From</label>
                <input type="date" class="form-control form-control-sm" id="start_date_from" name="start_date_from" value="<?php echo e(request('start_date_from')); ?>">
            </div>
            <div class="col-md-3 col-lg-2">
                <label for="start_date_to" class="form-label small mb-0">Start Date To</label>
                <input type="date" class="form-control form-control-sm" id="start_date_to" name="start_date_to" value="<?php echo e(request('start_date_to')); ?>">
            </div>

            <div class="col-md-3 col-lg-2">
                <label for="end_date_from" class="form-label small mb-0">End Date From</label>
                <input type="date" class="form-control form-control-sm" id="end_date_from" name="end_date_from" value="<?php echo e(request('end_date_from')); ?>">
            </div>
            <div class="col-md-3 col-lg-2">
                <label for="end_date_to" class="form-label small mb-0">End Date To</label>
                <input type="date" class="form-control form-control-sm" id="end_date_to" name="end_date_to" value="<?php echo e(request('end_date_to')); ?>">
            </div>

            <div class="col-md-3 col-lg-2">
                <label for="changed_by_user_id" class="form-label small mb-0">Changed By</label>
                <select class="form-select form-select-sm select2-filter" id="changed_by_user_id" name="changed_by_user_id">
                    <option value="">All Users</option>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($user->id); ?>" <?php echo e(request('changed_by_user_id') == $user->id ? 'selected' : ''); ?>>
                            <?php echo e($user->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-3 col-lg-2">
                <label for="reason" class="form-label small mb-0">Reason</label>
                <input type="text" class="form-control form-control-sm" id="reason" name="reason" value="<?php echo e(request('reason')); ?>">
            </div>

            <div class="col-md-3 col-lg-2">
                <label for="is_showroom_override" class="form-label small mb-0">Showroom Override</label>
                <select class="form-select form-select-sm" id="is_showroom_override" name="is_showroom_override">
                    <option value="">All</option>
                    <option value="1" <?php echo e(request('is_showroom_override') === '1' ? 'selected' : ''); ?>>Yes</option>
                    <option value="0" <?php echo e(request('is_showroom_override') === '0' ? 'selected' : ''); ?>>No</option>
                </select>
            </div>

            
            <div class="col-md-3 col-lg-2">
                <label for="showroom_id" class="form-label small mb-0">Showroom</label>
                <select class="form-select form-select-sm select2-filter" id="showroom_id" name="showroom_id">
                    <option value="">All Showrooms</option>
                    <?php $__currentLoopData = $showrooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $showroom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                        <option value="<?php echo e($showroom->id); ?>" <?php echo e(request('showroom_id') == $showroom->id ? 'selected' : ''); ?>>
                            <?php echo e($showroom->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-auto">
                <button type="submit" class="btn btn-sm btn-primary">
                    <i class="fas fa-filter"></i> Filter
                </button>
                <a href="<?php echo e(route('product_prices.index')); ?>" class="btn btn-sm btn-secondary ms-1">
                    <i class="fas fa-sync-alt"></i> Reset
                </a>
            </div>
        </form>
    </div>

    
    <div class="card card-body p-2">
        <div class="table-responsive">
            <table class="table table-sm table-bordered table-striped table-hover mb-0" id="productPricesTable">
                <thead class="bg-light">
                    <tr>
                        <th class="small py-1">Id</th>
                        <th class="small py-1">Product</th>
                        <th class="small py-1">Price</th>
                        <th class="small py-1">Start Date</th>
                        <th class="small py-1">End Date</th>
                        <th class="small py-1">Changed By</th>
                        <th class="small py-1">Reason</th>
                        <th class="small py-1">Showroom Override</th>
                        <th class="small py-1">Showroom</th>
                        <th class="small py-1 text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $productPrices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <!-- <td class="small py-1"><?php echo e($loop->iteration); ?></td> -->
                            <td class="small py-1"><?php echo e($price->id); ?></td>
                            <td class="small py-1"><?php echo e($price->product->productname ?? 'N/A'); ?></td>
                            <td class="small py-1"><?php echo e(number_format($price->price, 2)); ?></td>
                            <td class="small py-1"><?php echo e($price->effective_start_date->format('Y-m-d H:i')); ?></td>
                            <td class="small py-1"><?php echo e($price->effective_end_date ? $price->effective_end_date->format('Y-m-d H:i') : 'Active'); ?></td>
                            <td class="small py-1"><?php echo e($price->changedByUser->name ?? 'System'); ?></td>
                            <td class="small py-1"><?php echo e($price->reason ?? 'N/A'); ?></td>
                            <td class="small py-1"><?php echo e($price->is_showroom_override ? 'Yes' : 'No'); ?></td>
                            <td class="small py-1"><?php echo e($price->showroom->name ?? 'N/A'); ?></td>
                            <td class="small py-1 text-center">
                                <a href="<?php echo e(route('product_prices.edit', $price->id)); ?>" class="btn btn-sm btn-outline-primary py-0 px-1 me-1">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="<?php echo e(route('product_prices.destroy', $price->id)); ?>" method="POST" class="d-inline-block">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-sm btn-outline-danger py-0 px-1" onclick="return confirm('Are you sure you want to delete this price record?')">
                                        <i class="fas fa-trash-alt"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10" class="text-center small py-1">No product prices found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="mt-2 d-flex justify-content-center">
            <?php echo e($productPrices->links('pagination::bootstrap-5')); ?>

        </div>
    </div>
</div>


<div class="modal fade" id="syncPricesModal" tabindex="-1" aria-labelledby="syncPricesModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-header py-2 px-3">
                <h6 class="modal-title small" id="syncPricesModalLabel">Push Prices to Showroom(s)</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="<?php echo e(route('product_prices.sync_to_showroom')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body py-2 px-3">
                    <div class="mb-2">
                        <label for="apishowroom_ids" class="form-label small mb-0">Select Showroom(s):</label>
                        
                        <select class="form-select form-select-sm select2-modal <?php $__errorArgs = ['apishowroom_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="apishowroom_ids" name="apishowroom_ids[]" multiple="multiple" required>
                            <?php $__currentLoopData = $apishowrooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apishowroom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($apishowroom->id); ?>"><?php echo e($apishowroom->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <?php $__errorArgs = ['apishowroom_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback d-block small"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
                <div class="modal-footer py-2 px-3">
                    <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-sm btn-warning">Push Now</button>
                </div>
            </form>
        </div>
    </div>
</div>


<script>
    // Ensure select2 is initialized for filter dropdowns too
    $(document).ready(function() {
        $('.select2-filter').select2({
            theme: 'bootstrap-5',
            width: '100%',
            dropdownCssClass: 'select2-dropdown-sm', // Optional: for smaller dropdown
            selectionCssClass: 'select2-selection-sm', // Optional: for smaller selection box
            placeholder: 'Select...', // Placeholder for filter selects
            allowClear: true // Allow clearing selection
        });

        // Initialize select2 for the modal dropdown
        $('.select2-modal').select2({
            theme: 'bootstrap-5',
            width: '100%',
            dropdownParent: $('#syncPricesModal'), // Crucial for z-index issues within modals
            dropdownCssClass: 'select2-dropdown-sm',
            selectionCssClass: 'select2-selection-sm',
            placeholder: 'Select Showroom(s)',
            allowClear: true
        });

        // Clear modal select2 on modal close
        $('#syncPricesModal').on('hidden.bs.modal', function () {
            $('.select2-modal').val(null).trigger('change');
        });
    });

    function printTable() {
        printJS({
            printable: 'productPricesTable',
            type: 'html',
            header: '<h4>Product Prices Report</h4>',
            css: 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css',
            style: '@page { size: landscape; } table { width: 100%; border-collapse: collapse; } th, td { border: 1px solid #dee2e6; padding: .3rem; font-size: .75rem; } .table-sm th, .table-sm td { padding-top: .1rem; padding-bottom: .1rem; }'
        });
    }

    function exportTable() {
        const table = document.getElementById("productPricesTable");
        const worksheet = XLSX.utils.table_to_sheet(table);
        const workbook = XLSX.utils.book_new();
        XLSX.utils.book_append_sheet(workbook, worksheet, "ProductPrices");
        XLSX.writeFile(workbook, "product_prices.xlsx");
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/jpbspkpq/central.moscowbakers.top/resources/views/product_prices/index.blade.php ENDPATH**/ ?>