

<?php $__env->startSection('content'); ?>
<div class="container-fluid mt-3">
    <div class="card card-sm">
        <div class="card-header bg-primary text-white py-2">
            <h5 class="mb-0">Edit Discount Campaign: <?php echo e($discountCampaign->name); ?></h5>
        </div>
        <div class="card-body">
            <form action="<?php echo e(route('discount_campaigns.update', $discountCampaign->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-2">
                            <label for="name" class="form-label small">Campaign Name</label>
                            <input type="text" class="form-control form-control-sm <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="name" name="name" value="<?php echo e(old('name', $discountCampaign->name)); ?>" required>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-2">
                            <label for="discount_id" class="form-label small">Select Discount</label>
                            <select class="form-select form-select-sm select2 <?php $__errorArgs = ['discount_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="discount_id" name="discount_id" required>
                                <option value="">Select a Discount</option>
                                <?php $__currentLoopData = $discounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $discount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($discount->id); ?>" <?php echo e(old('discount_id', $discountCampaign->discount_id) == $discount->id ? 'selected' : ''); ?>>
                                        <?php echo e($discount->name); ?> (<?php echo e($discount->value); ?><?php echo e($discount->type == 'percentage' ? '%' : ''); ?> <?php echo e(ucfirst($discount->type)); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['discount_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-2">
                            <label for="discount_type" class="form-label small">Campaign Target Type</label>
                            <select class="form-select form-select-sm <?php $__errorArgs = ['discount_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="discount_type" name="discount_type" required>
                                <option value="">Select Target Type</option>
                                <option value="global" <?php echo e(old('discount_type', $discountCampaign->discount_type) == 'global' ? 'selected' : ''); ?>>Global</option>
                                <option value="category" <?php echo e(old('discount_type', $discountCampaign->discount_type) == 'category' ? 'selected' : ''); ?>>Category Specific</option>
                                <option value="products" <?php echo e(old('discount_type', $discountCampaign->discount_type) == 'products' ? 'selected' : ''); ?>>Product Specific (Multiple)</option>
                            </select>
                            <?php $__errorArgs = ['discount_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="col-md-6" id="category_select_container" style="display: <?php echo e(old('discount_type', $discountCampaign->discount_type) == 'category' ? 'block' : 'none'); ?>;">
                        <div class="mb-2">
                            <label for="category_name" class="form-label small">Select Category</label>
                            
                            <select class="form-select form-select-sm select2 <?php $__errorArgs = ['category_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="category_name" name="category_name">
                                <option value="">Select Category</option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category); ?>" <?php echo e(old('category_name', $discountCampaign->category_name) == $category ? 'selected' : ''); ?>><?php echo e($category); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            
                            
                            <?php $__errorArgs = ['category_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                    <div class="col-md-6" id="product_select_container" style="display: <?php echo e(old('discount_type', $discountCampaign->discount_type) == 'products' ? 'block' : 'none'); ?>;">
                        <div class="mb-2">
                            <label for="product_ids" class="form-label small">Select Products</label>
                            <select class="form-select form-select-sm select2 <?php $__errorArgs = ['product_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="product_ids" name="product_ids[]" multiple="multiple">
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($product->id); ?>" <?php echo e(in_array($product->id, old('product_ids', $discountCampaign->product_ids ?? [])) ? 'selected' : ''); ?>><?php echo e($product->productname); ?> (<?php echo e($product->productcategory); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['product_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <?php $__errorArgs = ['product_ids.*'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback small"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <div class="mb-2">
                    <label for="description" class="form-label small">Description</label>
                    <textarea class="form-control form-control-sm <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="description" name="description" rows="3"><?php echo e(old('description', $discountCampaign->description)); ?></textarea>
                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="invalid-feedback small"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div class="form-check form-switch mb-3">
                    <input class="form-check-input form-check-input-sm" type="checkbox" id="is_active" name="is_active" value="1" <?php echo e(old('is_active', $discountCampaign->is_active) ? 'checked' : ''); ?>>
                    <label class="form-check-label small" for="is_active">Is Active</label>
                </div>

                <button type="submit" class="btn btn-primary btn-sm">Update Campaign</button>
                <a href="<?php echo e(route('discount_campaigns.index')); ?>" class="btn btn-secondary btn-sm">Cancel</a>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Select2 for all select boxes
        $('.select2').select2({
            theme: 'bootstrap-5',
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: "Select an option",
            allowClear: true,
            containerCssClass: 'select2-container--small',
            selectionCssClass: 'select2-selection--small',
            dropdownCssClass: 'select2-dropdown--small',
        });

        const discountTypeSelect = document.getElementById('discount_type');
        const categorySelectContainer = document.getElementById('category_select_container');
        const productSelectContainer = document.getElementById('product_select_container');
        const categorySelect = document.getElementById('category_name');
        const productSelect = document.getElementById('product_ids');

        function toggleTargetFields() {
            const selectedType = discountTypeSelect.value;
            if (selectedType === 'category') {
                categorySelectContainer.style.display = 'block';
                productSelectContainer.style.display = 'none';
                // Do not clear product selection on edit unless discount type is explicitly changed
                // $(productSelect).val(null).trigger('change');
            } else if (selectedType === 'products') {
                productSelectContainer.style.display = 'block';
                categorySelectContainer.style.display = 'none';
                // Do not clear category selection on edit unless discount type is explicitly changed
                // $(categorySelect).val(null).trigger('change');
            } else { // global
                categorySelectContainer.style.display = 'none';
                productSelectContainer.style.display = 'none';
                // Do not clear selections on edit unless discount type is explicitly changed
                // $(categorySelect).val(null).trigger('change');
                // $(productSelect).val(null).trigger('change');
            }
        }

        // Initial call to set visibility based on current campaign data
        toggleTargetFields();

        // Add event listener for changes in discount type
        discountTypeSelect.addEventListener('change', toggleTargetFields);
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DEVELOPMENT\laragon-6.0.0\www\00central\resources\views/discount_campaigns/edit.blade.php ENDPATH**/ ?>