

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-2">
    <div class="d-flex justify-content-between align-items-center mb-2">
        <h4 class="mb-0">Edit Role: <?php echo e($role->name); ?></h4>
        <a href="<?php echo e(route('roles.index')); ?>" class="btn btn-secondary btn-sm">
            <i class="bi bi-arrow-left-circle me-1"></i> Back to List
        </a>
    </div>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger alert-dismissible fade show py-2 px-3 small" role="alert">
            <ul class="mb-0 ps-3">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card card-sm">
        <div class="card-body py-3 px-3">
            <form action="<?php echo e(route('roles.update', $role->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="mb-2">
                    <label for="name" class="form-label small mb-1">Role Name</label>
                    <input type="text" class="form-control form-control-sm" id="name" name="name" value="<?php echo e(old('name', $role->name)); ?>" required>
                </div>
                <div class="mb-2">
                    <label for="guard_name" class="form-label small mb-1">Guard Name</label>
                    <input type="text" class="form-control form-control-sm" id="guard_name" name="guard_name" value="<?php echo e(old('guard_name', $role->guard_name)); ?>" required>
                    <div class="form-text small">Commonly 'web' or 'api'.</div>
                </div>
                <div class="mb-3">
                    <label for="permissions" class="form-label small mb-1">Assign Permissions</label>
                    <select class="form-select form-select-sm select2" id="permissions" name="permissions[]" multiple="multiple">
                        <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($permission->id); ?>" <?php echo e(in_array($permission->id, old('permissions', $assignedPermissions)) ? 'selected' : ''); ?>>
                                <?php echo e($permission->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div class="form-text small">Select permissions to which this role will be assigned.</div>
                </div>
                <button type="submit" class="btn btn-primary btn-sm">
                    <i class="bi bi-arrow-repeat me-1"></i> Update Role
                </button>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/js/select2.min.js"></script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-rc.0/css/select2.min.css" rel="stylesheet" />
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize Select2 on all elements with class 'select2'
        $('.select2').select2({
            theme: 'bootstrap-5', // Use Bootstrap 5 theme for Select2
            width: $(this).data('width') ? $(this).data('width') : $(this).hasClass('w-100') ? '100%' : 'style',
            placeholder: 'Select permissions...',
            allowClear: true,
            dropdownParent: $('#permissions').parent() // Ensures dropdown is correctly positioned
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DEVELOPMENT\laragon-6.0.0\www\00central\resources\views/roles/edit.blade.php ENDPATH**/ ?>