

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-2">
    <h5 class="mb-3">Central Monthly Reports - <?php echo e($selectedMonth); ?></h5>

    <?php if(!empty($errors)): ?>
        <div class="alert alert-danger alert-sm">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="GET" action="<?php echo e(route('reports.centralcheck.index')); ?>" class="mb-3">
        <div class="row g-2 align-items-center">
            <div class="col-auto">
                <select name="month" class="form-select form-select-sm select2">
                    <?php for($i = 0; $i < 12; $i++): ?>
                        <option value="<?php echo e(\Carbon\Carbon::now()->subMonths($i)->format('Y-m')); ?>"
                            <?php echo e($selectedMonth == \Carbon\Carbon::now()->subMonths($i)->format('Y-m') ? 'selected' : ''); ?>>
                            <?php echo e(\Carbon\Carbon::now()->subMonths($i)->format('F Y')); ?>

                        </option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="col-auto">
                <select name="showroom" class="form-select form-select-sm select2">
                    <option value="">All Showrooms</option>
                    <?php $__currentLoopData = \App\Models\Apishowroom::where('is_active', true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $showroom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($showroom->identifier); ?>"
                            <?php echo e(request('showroom') == $showroom->identifier ? 'selected' : ''); ?>>
                            <?php echo e($showroom->name); ?> (<?php echo e($showroom->identifier); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-auto">
                <button type="submit" class="btn btn-primary btn-sm">Filter</button>
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-secondary btn-sm" id="print-report">Print</button>
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-success btn-sm" id="export-report">Export</button>
            </div>
        </div>
    </form>

    <?php $__currentLoopData = $allReports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(!request('showroom') || request('showroom') == $report['showroom_identifier']): ?>
            <div class="card mb-3">
                <div class="card-header small">
                    <?php echo e($report['showroom_name']); ?> (<?php echo e($report['showroom_identifier']); ?>)
                </div>
                <div class="card-body">
                    <div class="row">
                        
                        <div class="col-lg-8 col-md-12 mb-4">
                            <div class="card h-100">
                                <div class="card-header small">
                                    Monthly Summary
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped table-hover table-sm table-main-<?php echo e($index); ?>">
                                            <thead>
                                                <tr>
                                                    <th>Date</th>
                                                    <th>Receive</th>
                                                    <th>Factory Bill</th>
                                                    <th>Diff</th>
                                                    <th>Outside Products</th>
                                                    <th>Ingredients FG</th>
                                                    <th>Internal DOI</th>
                                                    <th>Diff After Deduction</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if(!empty($report['daily_data'])): ?>
                                                    <?php $__currentLoopData = $report['daily_data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($data['report_date']); ?></td>
                                                            <td><?php echo e(number_format($data['receive'], 2)); ?></td>
                                                            <td><?php echo e(number_format($data['factory_bill'], 2)); ?></td>
                                                            <td><?php echo e(number_format($data['diff'], 2)); ?></td>
                                                            <td><?php echo e(number_format($data['total_outside_products'], 2)); ?></td>
                                                            <td><?php echo e(number_format($data['ingredients_fg'], 2)); ?></td>
                                                            <td><?php echo e(number_format($data['internal_ingredients_used_doi'], 2)); ?></td>
                                                            <td><?php echo e(number_format($data['diff_after_deducting_outside_products'], 2)); ?></td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <tr><td colspan="8" class="text-center">No data available.</td></tr>
                                                <?php endif; ?>
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                    <th>Total</th>
                                                    <th><?php echo e(number_format($report['monthly_totals']['receive'], 2)); ?></th>
                                                    <th><?php echo e(number_format($report['monthly_totals']['factory_bill'], 2)); ?></th>
                                                    <th><?php echo e(number_format($report['monthly_totals']['diff'], 2)); ?></th>
                                                    <th><?php echo e(number_format($report['monthly_totals']['total_outside_products'], 2)); ?></th>
                                                    <th><?php echo e(number_format($report['monthly_totals']['ingredients_fg'], 2)); ?></th>
                                                    <th><?php echo e(number_format($report['monthly_totals']['internal_ingredients_used_doi'], 2)); ?></th>
                                                    <th><?php echo e(number_format($report['monthly_totals']['diff_after_deducting_outside_products'], 2)); ?></th>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        <div class="col-lg-4 col-md-12 mb-4">
                            <div class="card h-100">
                                <div class="card-header small">
                                    Daily Sales & Closing Stock
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-sm table-sales-<?php echo e($index); ?>">
                                            <thead>
                                                <tr class="table-info">
                                                    <th>Date</th>
                                                    <th>Total Sale</th>
                                                    <th>Total Closing Stock</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if(!empty($report['daily_data'])): ?>
                                                    <?php $__currentLoopData = $report['daily_data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><?php echo e($data['report_date']); ?></td>
                                                            <td><?php echo e(number_format($data['total_sale'], 2)); ?></td>
                                                            <td><?php echo e(number_format($data['total_closing_stock'], 2)); ?></td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <tr><td colspan="3" class="text-center">No data available for the selected month.</td></tr>
                                                <?php endif; ?>
                                            </tbody>
                                            <tfoot>
                                                <tr class="table-dark fw-bold">
                                                    <td>Monthly Total</td>
                                                    <td><?php echo e(number_format($report['monthly_totals']['total_sale'], 2)); ?></td>
                                                    <td><?php echo e(number_format($report['monthly_totals']['total_closing_stock'], 2)); ?></td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'default',
            width: 'auto',
        });
    });

    document.getElementById('print-report').addEventListener('click', function() {
        printJS({
            printable: document.querySelectorAll('.table'),
            type: 'html',
            header: 'Central Monthly Reports - <?php echo e($selectedMonth); ?>',
            css: ['https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css'],
        });
    });

    document.getElementById('export-report').addEventListener('click', function() {
        const wb = XLSX.utils.book_new();
        <?php $__currentLoopData = $allReports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(!request('showroom') || request('showroom') == $report['showroom_identifier']): ?>
                const wsMain = XLSX.utils.table_to_sheet(document.querySelector('.table-main-<?php echo e($index); ?>'));
                XLSX.utils.book_append_sheet(wb, wsMain, '<?php echo e($report['showroom_identifier']); ?>_Main');
                const wsSales = XLSX.utils.table_to_sheet(document.querySelector('.table-sales-<?php echo e($index); ?>'));
                XLSX.utils.book_append_sheet(wb, wsSales, '<?php echo e($report['showroom_identifier']); ?>_Sales');
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        XLSX.writeFile(wb, 'Central_Monthly_Reports_<?php echo e($selectedMonth); ?>.xlsx');
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DEVELOPMENT\laragon-6.0.0\www\00central\resources\views/reports/monthly_summary.blade.php ENDPATH**/ ?>