

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-flex justify-content-between mb-2">
        <h6 class="fw-bold">Showroom List</h6>
        <div>
            <a href="<?php echo e(route('sr.showroom.create')); ?>" class="btn btn-sm btn-primary">Add New</a>
            <button class="btn btn-sm btn-outline-secondary" onclick="printJS({ printable: 'report-table', type: 'html', css: 'bootstrap.css' })">Print</button>
            <button class="btn btn-sm btn-outline-success" onclick="exportToExcel()">Export</button>
        </div>
    </div>

    <form method="GET" class="row g-1 mb-2">
        <div class="col-auto">
            <input type="text" name="search" class="form-control form-control-sm" value="<?php echo e(request('search')); ?>" placeholder="Search...">
        </div>
        <div class="col-auto">
            <select name="status" class="form-select form-select-sm select2">
                <option value="">All Status</option>
                <option value="active" <?php if(request('status') == 'active'): echo 'selected'; endif; ?>>Active</option>
                <option value="inactive" <?php if(request('status') == 'inactive'): echo 'selected'; endif; ?>>Inactive</option>
            </select>
        </div>
        <div class="col-auto">
            <button type="submit" class="btn btn-sm btn-secondary">Filter</button>
        </div>
    </form>

    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover table-striped" id="report-table">
            <thead class="table-light text-center small">
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Code</th>
                    <th>City</th>
                    <th>Manager</th>
                    <th>Status</th>
                    <th class="text-nowrap">Actions</th>
                </tr>
            </thead>
            <tbody class="small">
                <?php $__currentLoopData = $showrooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $sr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($showrooms->firstItem() + $index); ?></td>
                    <td><?php echo e($sr->name); ?></td>
                    <td><?php echo e($sr->code); ?></td>
                    <td><?php echo e($sr->city); ?></td>
                    <td><?php echo e($sr->manager_name); ?></td>
                    <td>
                        <span class="badge bg-<?php echo e($sr->status === 'active' ? 'success' : 'secondary'); ?>"><?php echo e(ucfirst($sr->status)); ?></span>
                    </td>
                    <td class="text-nowrap">
                        <a href="<?php echo e(route('sr.showroom.edit', $sr)); ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                        <form action="<?php echo e(route('sr.showroom.destroy', $sr)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Delete showroom?');">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-outline-danger">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <div class="mt-2 small">
            <?php echo e($showrooms->withQueryString()->links('pagination::bootstrap-5')); ?>

        </div>
    </div>
</div>

<script>
    function exportToExcel() {
        const table = document.getElementById('report-table');
        const wb = XLSX.utils.table_to_book(table);
        XLSX.writeFile(wb, 'Showrooms.xlsx');
    }

    document.addEventListener('DOMContentLoaded', () => {
        $('.select2').select2({ width: 'resolve' });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DEVELOPMENT\laragon-6.0.0\www\00central\resources\views/sr/showroom/index.blade.php ENDPATH**/ ?>