

<?php $__env->startSection('content'); ?>
<div class="container py-3">
    <h5 class="mb-3">Central Drinks Reports</h5>

    <?php if(!empty($errors)): ?>
        <div class="alert alert-danger alert-sm">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="GET" action="<?php echo e(route('reports.central-drinks.index')); ?>" class="mb-3">
        <div class="row g-2 align-items-center">
            <div class="col-auto">
                <select name="year" class="form-select form-select-sm select2">
                    <?php $__currentLoopData = $years; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $yr): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($yr); ?>" <?php echo e($selectedYear == $yr ? 'selected' : ''); ?>><?php echo e($yr); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-auto">
                <select name="month" class="form-select form-select-sm select2">
                    <?php for($m = 1; $m <= 12; $m++): ?>
                        <option value="<?php echo e($m); ?>" <?php echo e($selectedMonth == $m ? 'selected' : ''); ?>>
                            <?php echo e(\Carbon\Carbon::create()->month((int)$m)->format('F')); ?>

                        </option>
                    <?php endfor; ?>
                </select>
            </div>
            <div class="col-auto">
                <select name="showroom" class="form-select form-select-sm select2">
                    <option value="">All Showrooms</option>
                    <?php $__currentLoopData = \App\Models\Apishowroom::where('is_active', true)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $showroom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($showroom->identifier); ?>"
                            <?php echo e(request('showroom') == $showroom->identifier ? 'selected' : ''); ?>>
                            <?php echo e($showroom->name); ?> (<?php echo e($showroom->identifier); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-auto">
                <button type="submit" class="btn btn-primary btn-sm">Filter</button>
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-secondary btn-sm" id="print-report">Print</button>
            </div>
            <div class="col-auto">
                <button type="button" class="btn btn-success btn-sm" id="export-report">Export</button>
            </div>
        </div>
    </form>

    <?php $__currentLoopData = $allReports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(!request('showroom') || request('showroom') == $report['showroom_identifier']): ?>
            <div class="card mb-3">
                <div class="card-header small">
                    <?php echo e($report['showroom_name']); ?> (<?php echo e($report['showroom_identifier']); ?>) - <?php echo e(\Carbon\Carbon::create()->month((int)$report['month'])->format('F')); ?> <?php echo e($report['year']); ?>

                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover table-sm table-drinks-<?php echo e($index); ?>">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <?php $__currentLoopData = $report['product_headers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $header): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <th><?php echo e($header['name']); ?> (<?php echo e($header['price']); ?>)</th>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <th>Daily Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(!empty($report['report_data'])): ?>
                                    <?php $__currentLoopData = $report['report_data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($data['date']); ?></td>
                                            <?php $__currentLoopData = $report['product_headers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $header): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <td><?php echo e($data['items'][$header['id']] ?? 0); ?></td>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <td><?php echo e($data['dailyTotal']); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <tr><td colspan="<?php echo e(count($report['product_headers']) + 2); ?>" class="text-center">No data available for the selected period.</td></tr>
                                <?php endif; ?>
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Total</th>
                                    <?php $__currentLoopData = $report['product_headers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $header): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <th><?php echo e($report['product_totals'][$header['id']] ?? 0); ?></th>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <th><?php echo e($report['grand_total']); ?></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'bootstrap-5',
            width: '100%',
        });
    });

    document.getElementById('print-report').addEventListener('click', function() {
        printJS({
            printable: document.querySelectorAll('.table'),
            type: 'html',
            header: 'Central Drinks Reports - <?php echo e($selectedYear); ?>-<?php echo e($selectedMonth); ?>',
            css: ['https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css'],
        });
    });

    document.getElementById('export-report').addEventListener('click', function() {
        const wb = XLSX.utils.book_new();
        <?php $__currentLoopData = $allReports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(!request('showroom') || request('showroom') == $report['showroom_identifier']): ?>
                const ws = XLSX.utils.table_to_sheet(document.querySelector('.table-drinks-<?php echo e($index); ?>'));
                XLSX.utils.book_append_sheet(wb, ws, '<?php echo e($report['showroom_identifier']); ?>');
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        XLSX.writeFile(wb, 'Central_Drinks_Reports_<?php echo e($selectedYear); ?>-<?php echo e($selectedMonth); ?>.xlsx');
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DEVELOPMENT\laragon-6.0.0\www\00central\resources\views/reports/drinksreport.blade.php ENDPATH**/ ?>