<nav class="navbar navbar-expand-lg navbar-light" style="background: linear-gradient(90deg, #74ebd5, #ACB6E5);">
    <div class="container-fluid">
        <a class="navbar-brand fw-bold text-white" href="<?php echo e(url('/')); ?>">
            <?php echo e(config('app.name', 'Laravel')); ?>

        </a>

        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMegaMenu" aria-controls="navbarMegaMenu" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="navbarMegaMenu">
            <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                
                <li class="nav-item">
                    <a class="nav-link text-white" href="<?php echo e(route('dashboard')); ?>">
                        Dashboard
                    </a>
                </li>

                
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Settings
                    </a>
                    <ul class="dropdown-menu shadow">
                        <li><a class="dropdown-item " href="<?php echo e(route('users.index')); ?>">Users</a></li>
                        <li><a class="dropdown-item " href="<?php echo e(route('profile.edit')); ?>">Profile</a></li>
                        <li><a class="dropdown-item " href="<?php echo e(route('roles.index')); ?>">Roles</a></li>
                        <li><a class="dropdown-item " href="<?php echo e(route('permissions.index')); ?>">Permissions</a></li>
                    </ul>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Showroom Management
                    </a>
                    <ul class="dropdown-menu shadow">
                        <li class="dropdown-submenu dropend">
                            <a class="dropdown-item dropdown-toggle " href="#">
                                Showrooms
                            </a>
                            <ul class="dropdown-menu shadow">
                                <li>
                                    <a class="dropdown-item " href="<?php echo e(route('sr.showroom.index')); ?>">
                                        All Showrooms
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item " href="<?php echo e(route('sr.showroom.create')); ?>">
                                        Add Showroom
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </li>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Inventory
                    </a>
                    <ul class="dropdown-menu shadow">
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('products.index')); ?>">Products</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link " href="<?php echo e(route('stocks.table')); ?>">Daily Stock</a>
                        </li>
                        <li class="nav-item"><a class="nav-link" href="<?php echo e(route('product_prices.index')); ?>">Product Prices</a></li>
                        <li class="nav-item"><a class="nav-link" href="<?php echo e(route('discount_campaigns.index')); ?>">Discount Campaign</a></li>
                        <li class="nav-item"><a class="nav-link" href="<?php echo e(route('discounts.index')); ?>">Discount list</a></li>
                        <li class="nav-item"><a class="nav-link "    href="<?php echo e(route('reports.centralcheck.index')); ?>">Check Report - Bill Check</a></li>
                        <li class="nav-item"><a class="nav-link "    href="<?php echo e(route('rates.central-reports.index')); ?>">Check Report - Return Check</a></li>
                        
                        <li class="nav-item"><a class="nav-link "    href="<?php echo e(route('reports.central-drinks.index')); ?>">Drinks Report</a></li>
                    </ul>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Sales
                    </a>
                    <ul class="dropdown-menu shadow">
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('apidmysales.create')); ?>">Received Sales Report</a>
                           
                        </li>
                    </ul>

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle text-white" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Admin
                    </a>
                    <ul class="dropdown-menu shadow">
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('generate_showroom_token')); ?>">
                                Token
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link " href="<?php echo e(route('admin.sync.dashboard')); ?>">
                                sync dashboard
                            </a>
                        </li>
                    </ul>
                </li>

            </ul>

            
            <ul class="navbar-nav ms-auto mb-2 mb-lg-0">
                <?php if(auth()->guard()->guest()): ?>
                    <?php if(Route::has('login')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a>
                        </li>
                    <?php endif; ?>
                    <?php if(Route::has('register')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white" href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a>
                        </li>
                    <?php endif; ?>
                <?php else: ?>
                    <li class="nav-item dropdown">
                        <a id="navbarDropdown" class="nav-link dropdown-toggle text-white" href="#" role="button" data-bs-toggle="dropdown">
                            <?php echo e(Auth::user()->name); ?>

                        </a>

                        <ul class="dropdown-menu dropdown-menu-end shadow">
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                   onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                    <?php echo e(__('Logout')); ?>

                                </a>
                            </li>
                        </ul>

                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none"><?php echo csrf_field(); ?></form>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>
<?php /**PATH /home/jpbspkpq/central.moscowbakers.top/resources/views/layouts/navbar.blade.php ENDPATH**/ ?>