<?php $__env->startSection('content'); ?>
<div class="container-fluid py-2">
    <div class="d-flex justify-content-between align-items-center mb-2">
        <h4 class="mb-0">Users List</h4>
        <div>
            <a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary btn-sm me-2">
                <i class="bi bi-plus-circle me-1"></i> Create New User
            </a>
            <button id="printTable" class="btn btn-info btn-sm me-2">
                <i class="bi bi-printer me-1"></i> Print Report
            </button>
            <button id="exportTable" class="btn btn-success btn-sm">
                <i class="bi bi-file-earmark-excel me-1"></i> Export to Excel
            </button>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show py-2 px-3 small" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="mb-3">
        <form action="<?php echo e(route('users.index')); ?>" method="GET" class="d-flex">
            <input type="text" name="search" class="form-control form-control-sm me-2" placeholder="Search by name or email..." value="<?php echo e($search ?? ''); ?>">
            <button type="submit" class="btn btn-outline-secondary btn-sm">
                <i class="bi bi-search"></i> Search
            </button>
            <?php if($search): ?>
                <a href="<?php echo e(route('users.index')); ?>" class="btn btn-outline-danger btn-sm ms-2">
                    <i class="bi bi-x-circle"></i> Clear
                </a>
            <?php endif; ?>
        </form>
    </div>

    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover table-sm align-middle" id="usersTable">
            <thead class="table-light">
                <tr>
                    <th scope="col" class="py-1 px-2">#</th>
                    <th scope="col" class="py-1 px-2">Name</th>
                    <th scope="col" class="py-1 px-2">Email</th>
                    <th scope="col" class="py-1 px-2">Roles</th>
                    <th scope="col" class="py-1 px-2">Showroom</th>
                    <th scope="col" class="py-1 px-2 text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="py-1 px-2"><?php echo e($loop->iteration); ?></td>
                        <td class="py-1 px-2"><?php echo e($user->name); ?></td>
                        <td class="py-1 px-2"><?php echo e($user->email); ?></td>
                        <td class="py-1 px-2">
                            <?php $__empty_2 = true; $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                <span class="badge bg-primary rounded-pill small"><?php echo e($role->name); ?></span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                <span class="badge bg-secondary rounded-pill small">No Roles</span>
                            <?php endif; ?>
                        </td>
                        <td class="py-1 px-2">
                            <?php echo e($user->showroom ? $user->showroom->name : 'N/A'); ?>

                        </td>
                        <td class="py-1 px-2 text-center">
                            <a href="<?php echo e(route('users.edit', $user->id)); ?>" class="btn btn-info btn-sm me-1 py-0 px-2">
                                <i class="bi bi-pencil-square"></i> Edit
                            </a>
                            <button type="button" class="btn btn-danger btn-sm py-0 px-2" data-bs-toggle="modal" data-bs-target="#deleteUserModal" data-id="<?php echo e($user->id); ?>">
                                <i class="bi bi-trash"></i> Delete
                            </button>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="text-center py-2 px-2">No users found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-center mt-3">
        <?php echo e($users->links('pagination::bootstrap-5')); ?>

    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteUserModal" tabindex="-1" aria-labelledby="deleteUserModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-header bg-danger text-white py-2 px-3">
                <h6 class="modal-title mb-0" id="deleteUserModalLabel">Confirm Deletion</h6>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body small py-3 px-3">
                Are you sure you want to delete this user? This action cannot be undone.
            </div>
            <div class="modal-footer py-2 px-3">
                <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST" action="">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdnjs.cloudflare.com/ajax/libs/print.js/1.6.0/print.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script>
    // Delete Confirmation Modal Script
    document.addEventListener('DOMContentLoaded', function () {
        const deleteUserModal = document.getElementById('deleteUserModal');
        deleteUserModal.addEventListener('show.bs.modal', function (event) {
            const button = event.relatedTarget;
            const userId = button.getAttribute('data-id');
            const deleteForm = deleteUserModal.querySelector('#deleteForm');
            deleteForm.action = `/users/${userId}`; // Adjust route path if necessary
        });

        // Print.js integration
        document.getElementById('printTable').addEventListener('click', function() {
            printJS({
                printable: 'usersTable',
                type: 'html',
                header: '<h4 class="text-center">Users Report</h4>',
                css: 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css',
                style: `
                    table { width: 100%; border-collapse: collapse; }
                    th, td { border: 1px solid #dee2e6; padding: .3rem; text-align: left; font-size: 0.85rem; }
                    .table-sm th, .table-sm td { padding: .2rem .4rem; }
                    .table-striped tbody tr:nth-of-type(odd) { background-color: rgba(0, 0, 0, 0.05); }
                    .table-hover tbody tr:hover { background-color: rgba(0, 0, 0, 0.075); }
                    .text-center { text-align: center; }
                    .align-middle { vertical-align: middle; }
                    .btn { display: none; } /* Hide buttons in print */
                    .pagination { display: none; } /* Hide pagination in print */
                    .search-form { display: none; } /* Hide search form in print */
                `
            });
        });

        // Sheet.js integration for export
        document.getElementById('exportTable').addEventListener('click', function() {
            const table = document.getElementById('usersTable');
            const ws = XLSX.utils.table_to_sheet(table);

            // Remove the "Actions" column from the exported sheet
            if (ws['!cols']) {
                ws['!cols'].pop(); // Remove the last column definition
            }
            // Iterate through rows and remove the last cell (Actions)
            const range = XLSX.utils.decode_range(ws['!ref']);
            for (let R = range.s.r; R <= range.e.r; ++R) {
                const cellAddress = XLSX.utils.encode_cell({ r: R, c: range.e.c });
                delete ws[cellAddress];
            }
            // Adjust the range to exclude the last column
            range.e.c--;
            ws['!ref'] = XLSX.utils.encode_range(range);

            const wb = XLSX.utils.book_new();
            XLSX.utils.book_append_sheet(wb, ws, "Users");
            XLSX.writeFile(wb, "users_report.xlsx");
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DEVELOPMENT\laragon-6.0.0\www\00central\resources\views/users/index.blade.php ENDPATH**/ ?>