

<?php $__env->startSection('content'); ?>
<div class="container-fluid small">
    <div class="d-flex justify-content-between mb-2">
        <h6 class="fw-bold">Product List</h6>
        <div>
            <a href="<?php echo e(route('products.create')); ?>" class="btn btn-sm btn-primary">Add Product</a>
            <button class="btn btn-sm btn-outline-secondary" onclick="printJS({ printable: 'product-table', type: 'html' })">Print</button>
            <button class="btn btn-sm btn-outline-success" onclick="exportToExcel()">Export</button>
            <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#syncProductsModal">
                <i class="fas fa-cloud-upload-alt"></i> Push Products to showroom(s)
            </button>
            <form action="<?php echo e(route('products.syncPrices')); ?>" method="POST" style="display:inline;" onsubmit="return confirm('Are you sure you want to sync product prices from the Products table? This will update existing prices and add new ones for the effective date 2025-06-01.');">
                <?php echo csrf_field(); ?> 
                <button type="submit" class="btn btn-sm btn-info">
                    <i class="fas fa-sync-alt"></i> Send Product Data (internal)
                </button>
            </form>
        </div>
    </div>

    <form method="GET" class="row g-1 mb-2 align-items-end"> 
        <div class="col-auto">
            <label for="search_productname" class="form-label small mb-0">Name/Code:</label>
            <input type="text" id="search_productname" name="search" class="form-control form-control-sm" value="<?php echo e(request('search')); ?>" placeholder="Search by name, barcode, SKU, custom no">
        </div>
        
        <div class="col-auto">
            <label for="search_barcode" class="form-label small mb-0">Barcode:</label>
            <input type="text" id="search_barcode" name="barcode" class="form-control form-control-sm" value="<?php echo e(request('barcode')); ?>" placeholder="Barcode">
        </div>
        <div class="col-auto">
            <label for="search_sku" class="form-label small mb-0">SKU:</label>
            <input type="text" id="search_sku" name="sku" class="form-control form-control-sm" value="<?php echo e(request('sku')); ?>" placeholder="SKU">
        </div>
        <div class="col-auto">
            <label for="search_custom_no" class="form-label small mb-0">Custom No:</label>
            <input type="text" id="search_custom_no" name="custom_no" class="form-control form-control-sm" value="<?php echo e(request('custom_no')); ?>" placeholder="Custom No">
        </div>
        <div class="col-auto">
            <label for="search_unit" class="form-label small mb-0">Unit:</label>
            <input type="text" id="search_unit" name="unit" class="form-control form-control-sm" value="<?php echo e(request('unit')); ?>" placeholder="Unit">
        </div>
        <div class="col-auto">
            <label for="search_status" class="form-label small mb-0">Status:</label>
            <input type="text" id="search_status" name="status" class="form-control form-control-sm" value="<?php echo e(request('status')); ?>" placeholder="Status">
        </div>
        <div class="col-auto">
            <label for="search_showroom" class="form-label small mb-0">Showroom:</label>
            <select name="showroom_id" id="search_showroom" class="form-select form-select-sm">
                <option value="">All Showrooms</option>
                <?php $__currentLoopData = $apishowrooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apishowroom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($apishowroom->id); ?>" <?php echo e((string)request('showroom_id') === (string)$apishowroom->id ? 'selected' : ''); ?>>
                        <?php echo e($apishowroom->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="col-auto">
            <button type="submit" class="btn btn-sm btn-secondary">Filter</button>
            <a href="<?php echo e(route('products.index')); ?>" class="btn btn-sm btn-outline-secondary">Clear</a> 
        </div>
    </form>

    <div class="table-responsive">
        <table class="table table-sm table-bordered table-striped table-hover" id="product-table">
            <thead class="table-light text-center small">
                <tr>
                    <th>ID</th>
                    <th>Date</th>
                    <th>Name</th>
                    <th>Department</th>
                    <th>Category</th>
                    <th>Barcode</th> 
                    <th>SKU</th> 
                    <th>Custom No</th> 
                    <th>Unit</th> 
                    <th>Status</th> 
                    <th>Showroom</th> 
                    <th class="text-end">Price</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody class="small">
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="text-center"><?php echo e($p->id); ?></td>
                    <td><?php echo e($p->dateofentry->format('Y-m-d')); ?></td>
                    <td><?php echo e($p->productname); ?></td>
                    <td><?php echo e($p->productiondepartment); ?></td>
                    <td><?php echo e($p->productcategory); ?></td>
                    <td><?php echo e($p->barcode); ?></td> 
                    <td><?php echo e($p->sku); ?></td> 
                    <td><?php echo e($p->custom_no); ?></td> 
                    <td><?php echo e($p->unit); ?></td> 
                    <td><?php echo e($p->status); ?></td> 
                    <td><?php echo e($p->showroom->name ?? 'N/A'); ?></td> 
                    <td class="text-end"><?php echo e(number_format($p->price, 2)); ?></td>
                    <td class="text-nowrap">
                        <a href="<?php echo e(route('products.edit', $p)); ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                        <form action="<?php echo e(route('products.destroy', $p)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Delete?')">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button class="btn btn-sm btn-outline-danger">Del</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        
        <div class="modal fade" id="syncProductsModal" tabindex="-1" aria-labelledby="syncProductsModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-sm">
                <div class="modal-content">
                    <div class="modal-header py-2 px-3">
                        <h6 class="modal-title small" id="syncProductsModalLabel">Push Products to Showroom(s)</h6>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form action="<?php echo e(route('sync.products')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body py-2 px-3">
                            <div class="mb-2">
                                <label for="apishowroom_ids_products" class="form-label small mb-0">Select Showroom(s):</label>
                                <select class="form-select form-select-sm select2-modal <?php $__errorArgs = ['apishowroom_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="apishowroom_ids_products" name="apishowroom_ids[]" multiple required>
                                    <?php $__currentLoopData = $apishowrooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apishowroom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($apishowroom->id); ?>"><?php echo e($apishowroom->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['apishowroom_ids'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback d-block small"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="modal-footer py-2 px-3">
                            <button type="button" class="btn btn-sm btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-sm btn-warning">Sync Now</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="mt-2 small">
            <?php echo e($products->withQueryString()->links('pagination::bootstrap-5')); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
    $('#syncProductsModal').on('shown.bs.modal', function () {
        $('#apishowroom_ids_products').select2({
            theme: 'bootstrap-5',
            dropdownParent: $('#syncProductsModal'),
            width: '100%',
            placeholder: 'Select Showroom(s)',
            allowClear: true
        });
    });

    function exportToExcel() {
        const wb = XLSX.utils.table_to_book(document.getElementById('product-table'));
        XLSX.writeFile(wb, 'Products.xlsx');
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/jpbspkpq/central.moscowbakers.top/resources/views/fac/products/index.blade.php ENDPATH**/ ?>