 

<?php $__env->startSection('content'); ?>
<div class="container-fluid small">
    <div class="d-flex justify-content-between mb-2">
        <h6 class="fw-bold">Last Received Sales Report (Central Office View)</h6>
        <a href="#" class="btn btn-sm btn-secondary">Back to Dashboard</a>
    </div>

    <?php if(!isset($reports) || empty($reports['report1']['data'])): ?>
        <div class="alert alert-info text-center" role="alert">
            No sales report has been received yet, or the session data has expired.
            Please ensure a showroom sends a report via the API.
        </div>
    <?php else: ?>
        
        <div class="card mb-4">
            <div class="card-header" id="report1Heading"><?php echo e($reports['report1']['heading1']); ?></div>
            <div class="card-body">
                <h6 class="card-subtitle mb-2 text-muted" id="report1SubHeading"><?php echo e($reports['report1']['heading2']); ?></h6>
                <div class="table-responsive">
                    <table class="table table-sm table-bordered">
                        <thead>
                            <tr id="report1TableHeaders">
                                <?php $__currentLoopData = $reports['report1']['columns']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <th><?php echo e($column); ?></th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        </thead>
                        <tbody id="report1TableBody">
                            <?php $__currentLoopData = $reports['report1']['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($row['date']); ?></td>
                                    <td><?php echo e($row['total_sale']); ?></td>
                                    <td><?php echo e($row['discount']); ?></td>
                                    <td><?php echo e($row['net_sale']); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot id="report1TableFoot">
                            <tr>
                                <th colspan="1">Total</th>
                                <th><?php echo e($reports['report1']['total']['total_sale']); ?></th>
                                <th><?php echo e($reports['report1']['total']['total_discount']); ?></th>
                                <th><?php echo e($reports['report1']['total']['total_net_sale']); ?></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        
        <div class="card mb-4">
            <div class="card-header" id="report2Heading"><?php echo e($reports['report2']['heading1']); ?></div>
            <div class="card-body">
                <h6 class="card-subtitle mb-2 text-muted" id="report2SubHeading"><?php echo e($reports['report2']['heading2']); ?></h6>
                <div class="table-responsive">
                    <table class="table table-sm table-bordered">
                        <thead>
                            <tr id="report2TableHeaders">
                                <?php $__currentLoopData = $reports['report2']['columns']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <th><?php echo e($column); ?></th>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        </thead>
                        <tbody id="report2TableBody">
                            <?php $__currentLoopData = $reports['report2']['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($row['date']); ?></td>
                                    <td><?php echo e($row['productname']); ?></td>
                                    <td><?php echo e($row['productcategory']); ?></td>
                                    <td><?php echo e($row['productiondepartment']); ?></td>
                                    <td><?php echo e($row['amount']); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot id="report2TableFoot">
                            <tr>
                                <th colspan="4">Total</th>
                                <th><?php echo e($reports['report2']['total']['total_amount']); ?></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>

        
        <div class="card mb-4">
            <div class="card-header fw-bold">Raw Received Data</div>
            <div class="card-body">
                <pre class="bg-light p-3 rounded small"><?php echo e(json_encode($reports['filters_applied'], JSON_PRETTY_PRINT)); ?></pre>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DEVELOPMENT\laragon-6.0.0\www\00central\resources\views/pos/received_sales_viewer.blade.php ENDPATH**/ ?>