

<?php $__env->startSection('content'); ?>
<div class="container-fluid mt-3">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">Discount Campaigns</h5>
        
        <div>
            <form action="<?php echo e(route('syncDiscountData.showrooms')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <button type="submit" class="btn btn-sm btn-primary">Sync Data to Showrooms</button>
            </form>
            <a href="<?php echo e(route('discount_campaigns.create')); ?>" class="btn btn-primary btn-sm me-2">Create New Campaign</a>
            <button id="printTable" class="btn btn-info btn-sm me-2">Print Report</button>
            <button id="exportTable" class="btn btn-success btn-sm">Export to Excel</button>
        </div>
    </div>

   <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('success')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if(session('warning')): ?>
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <?php echo e(session('warning')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="table-responsive">
        <table class="table table-bordered table-striped table-hover table-sm" id="discountCampaignsTable">
            <thead class="table-light">
                <tr>
                    <th scope="col">#</th>
                    <th scope="col">Campaign Name</th>
                    <th scope="col">Discount Name</th>
                    <th scope="col">Discount Value</th>
                    <th scope="col">Discount Type</th>
                    <th scope="col">Target Type</th>
                    <th scope="col">Target</th>
                    <th scope="col">Start Date</th>
                    <th scope="col">End Date</th>
                    <th scope="col">Active</th>
                    <th scope="col" class="text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $discountCampaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($campaign->name); ?></td>
                        <td><?php echo e($campaign->discount->name ?? 'N/A'); ?></td>
                        <td><?php echo e($campaign->discount->value ?? 'N/A'); ?> <?php echo e(($campaign->discount && $campaign->discount->type == 'percentage') ? '%' : ''); ?></td>
                        <td><?php echo e(ucfirst($campaign->discount->type ?? 'N/A')); ?></td>
                        <td><?php echo e(ucfirst($campaign->discount_type)); ?></td>
                        <td>
                            <?php if($campaign->discount_type == 'products'): ?>
                                
                                <?php if($campaign->relatedProducts->isNotEmpty()): ?>
                                    <ul class="list-unstyled mb-0 small">
                                        <?php $__currentLoopData = $campaign->relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($product->productname); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            <?php elseif($campaign->discount_type == 'category'): ?>
                                <?php echo e($campaign->category_name); ?>

                            <?php else: ?>
                                Global
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($campaign->discount->start_date->format('Y-m-d') ?? 'N/A'); ?></td>
                        <td><?php echo e($campaign->discount->end_date->format('Y-m-d') ?? 'N/A'); ?></td>
                        <td>
                            <span class="badge <?php echo e($campaign->is_active ? 'bg-success' : 'bg-danger'); ?>">
                                <?php echo e($campaign->is_active ? 'Yes' : 'No'); ?>

                            </span>
                        </td>
                        <td class="text-center">
                            <a href="<?php echo e(route('discount_campaigns.edit', $campaign->id)); ?>" class="btn btn-warning btn-sm me-1">Edit</a>
                            <form action="<?php echo e(route('discount_campaigns.destroy', $campaign->id)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this campaign?')">Delete</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="11" class="text-center">No discount campaigns found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-center">
        <?php echo e($discountCampaigns->links('pagination::bootstrap-5')); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Print functionality
        document.getElementById('printTable').addEventListener('click', function() {
            printJS({
                printable: 'discountCampaignsTable',
                type: 'html',
                header: '<h3>Discount Campaigns Report</h3>',
                css: 'https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css',
                style: '@page { size: landscape; } table { width: 100%; border-collapse: collapse; } th, td { border: 1px solid #ddd; padding: 8px; }'
            });
        });

        // Export to Excel functionality
        document.getElementById('exportTable').addEventListener('click', function() {
            let table = document.getElementById('discountCampaignsTable');
            let ws = XLSX.utils.table_to_sheet(table);
            let wb = XLSX.utils.book_new();
            XLSX.utils.book_append_sheet(wb, ws, "Discount Campaigns");
            XLSX.writeFile(wb, "DiscountCampaigns.xlsx");
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DEVELOPMENT\laragon-6.0.0\www\00central\resources\views/discount_campaigns/index.blade.php ENDPATH**/ ?>