

<?php $__env->startSection('content'); ?>
<div class="container-fluid p-2">
    <h6 class="mb-3">Showroom Management</h6>

    <?php if(session('success')): ?>
        <div class="alert alert-success py-1 px-2 small">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    
    <?php if(session('sync_results')): ?>
    <div class="alert alert-info py-1 px-2 small mt-2">
        <strong>Sync Summary:</strong>
        <ul class="mb-0">
            <?php $__currentLoopData = session('sync_results'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li>
                    <?php echo e($res['showroom']); ?> —
                    <span class="<?php echo e($res['status'] === 'Success' ? 'text-success' : 'text-danger'); ?>">
                        <?php echo e($res['status']); ?>

                    </span>
                    <?php if(!empty($res['error'])): ?>
                        <small class="text-muted">(<?php echo e($res['error']); ?>)</small>
                    <?php endif; ?>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>

<form method="GET" action="<?php echo e(route('admin.sync.dashboard')); ?>" class="row g-2 mb-3 small">
    <div class="col-auto">
        <input type="date" name="from" class="form-control form-control-sm"
               value="<?php echo e(request('from') ?? now()->subDay()->toDateString()); ?>">
    </div>
    <div class="col-auto">
        <input type="date" name="to" class="form-control form-control-sm"
               value="<?php echo e(request('to') ?? now()->toDateString()); ?>">
    </div>
    <div class="col-auto">
        <button type="submit" class="btn btn-sm btn-outline-primary">Apply</button>
    </div>
</form>


    
    <form method="POST" action="<?php echo e(route('admin.showrooms.store')); ?>" class="row g-2 mb-3 small">
        <?php echo csrf_field(); ?>
        <div class="col-auto">
            <input type="text" name="name" class="form-control form-control-sm" placeholder="Name" required>
        </div>
        <div class="col-auto">
            <input type="text" name="identifier" class="form-control form-control-sm" placeholder="Identifier" required>
        </div>
        <div class="col-auto">
            <input type="url" name="api_url" class="form-control form-control-sm" placeholder="API URL" required>
        </div>
        <div class="col-auto">
            <input type="text" name="api_token" class="form-control form-control-sm" placeholder="API Token">
        </div>
        <div class="col-auto">
            <select name="status" class="form-select form-select-sm select2" required>
                <option value="active">Active</option>
                <option value="inactive">Inactive</option>
            </select>
        </div>
        <div class="col-auto">
            <button type="submit" class="btn btn-sm btn-primary">Add</button>
        </div>
        <div class="col-auto">
        <form method="POST" action="<?php echo e(route('admin.sync.pull_all_stock')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="from" value="<?php echo e(request('from') ?? now()->subDay()->toDateString()); ?>">
            <input type="hidden" name="to" value="<?php echo e(request('to') ?? now()->toDateString()); ?>">
            <button type="submit" class="btn btn-sm btn-dark">Sync All</button>
        </form>
    </div>
        <div class="col-auto">
            <button onclick="window.print()" type="button" class="btn btn-sm btn-secondary">Print</button>
            <button onclick="sheetExport()" type="button" class="btn btn-sm btn-success">Export</button>
        </div>
    </form>

    
    <table class="table table-sm table-bordered table-striped table-hover small" id="showrooms-table">
        <thead class="table-light">
            <tr>
                <th>Name</th>
                <th>Identifier</th>
                <th>Status</th>
                <th>API URL</th>
                <th>Last Pulled</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $apishowrooms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $showroom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($showroom->name); ?></td>
                <td><?php echo e($showroom->identifier); ?></td>
                <td class="text-capitalize"><?php echo e($showroom->is_active ? 'active' : 'inactive'); ?></td>
                <td class="text-truncate" style="max-width: 160px;"><?php echo e($showroom->api_url); ?></td>
                <td><?php echo e($showroom->last_pulled_at ?? '-'); ?></td>
                <td class="text-nowrap">

                    
                   <form method="POST" action="<?php echo e(route('admin.showrooms.pull_stock', $showroom)); ?>" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="from" value="<?php echo e(request('from') ?? now()->subDay()->toDateString()); ?>">
                    <input type="hidden" name="to" value="<?php echo e(request('to') ?? now()->toDateString()); ?>">
                    <button type="submit" class="btn btn-sm btn-outline-info">Pull</button>
                </form>

                    

                    
                    <form method="POST" action="<?php echo e(route('admin.showrooms.toggle_status', $showroom)); ?>" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="btn btn-sm btn-outline-warning">
                            <?php echo e($showroom->is_active ? 'Deactivate' : 'Activate'); ?>

                        </button>
                    </form>

                    
                    <form method="POST" action="<?php echo e(route('admin.showrooms.destroy', $showroom)); ?>" class="d-inline">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-sm btn-outline-danger" onclick="return confirm('Delete this showroom?')">Del</button>
                    </form>

                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="mt-2">
        <?php echo e($apishowrooms->links('pagination::bootstrap-5')); ?>

    </div>
</div>


<script>
function sheetExport() {
    const table = document.getElementById('showrooms-table');
    const wb = XLSX.utils.table_to_book(table);
    XLSX.writeFile(wb, 'showrooms.xlsx');
}
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DEVELOPMENT\laragon-6.0.0\www\00central\resources\views/admin/sync/dashboard.blade.php ENDPATH**/ ?>