

<?php $__env->startSection('content'); ?>
<div class="container-fluid mt-2">
    <?php if(session('error')): ?>
        <div class="alert alert-danger alert-sm"><?php echo e(session('error')); ?></div>
    <?php endif; ?>
    <?php if(session('warning')): ?>
        <div class="alert alert-warning alert-sm"><?php echo e(session('warning')); ?></div>
    <?php endif; ?>

    <form method="GET" action="<?php echo e(route('apidmysales.index')); ?>" class="card mb-2">
        <div class="card-header p-1">
            <h5 class="m-0">Search Report</h5>
        </div>
        <div class="card-body p-2">
            <div class="row">
                <div class="col-md-3 mb-1">
                    <label class="form-label small">Showroom</label>
                    <select name="showroom_id" class="form-control form-control-sm select2">
                        <option value="all">All Showrooms</option>
                        <?php $__currentLoopData = $showrooms ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $showroom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($showroom['id']); ?>" <?php echo e(old('showroom_id', $filters['showroom_id'] ?? '') == $showroom['id'] ? 'selected' : ''); ?>><?php echo e($showroom['name']); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">From Date</label>
                    <input type="date" name="from_date" class="form-control form-control-sm" value="<?php echo e(old('from_date', $filters['from_date'] ?? '')); ?>">
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">To Date</label>
                    <input type="date" name="to_date" class="form-control form-control-sm" value="<?php echo e(old('to_date', $filters['to_date'] ?? '')); ?>">
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">Product Name</label>
                    <select name="productname" class="form-control form-control-sm select2">
                        <option value="">Select Product</option>
                        <?php $__currentLoopData = $productNames ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($name); ?>" <?php echo e(old('productname', $filters['productname'] ?? '') == $name ? 'selected' : ''); ?>><?php echo e($name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">Product Category</label>
                    <select name="productcategory" class="form-control form-control-sm select2">
                        <option value="">Select Category</option>
                        <?php $__currentLoopData = $productCategories ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category); ?>" <?php echo e(old('productcategory', $filters['productcategory'] ?? '') == $category ? 'selected' : ''); ?>><?php echo e($category); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">Production Department</label>
                    <select name="productiondepartment" class="form-control form-control-sm select2">
                        <option value="">Select Department</option>
                        <?php $__currentLoopData = $productionDepartments ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($department); ?>" <?php echo e(old('productiondepartment', $filters['productiondepartment'] ?? '') == $department ? 'selected' : ''); ?>><?php echo e($department); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">Barcode</label>
                    <input type="text" name="barcode" class="form-control form-control-sm" value="<?php echo e(old('barcode', $filters['barcode'] ?? '')); ?>">
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">SKU</label>
                    <input type="text" name="sku" class="form-control form-control-sm" value="<?php echo e(old('sku', $filters['sku'] ?? '')); ?>">
                </div>
                <div class="col-md-3 mb-1">
                    <label class="form-label small">Custom No</label>
                    <input type="text" name="custom_no" class="form-control form-control-sm" value="<?php echo e(old('custom_no', $filters['custom_no'] ?? '')); ?>">
                </div>
            </div>
        </div>
        <div class="card-footer p-1">
            <button type="submit" class="btn btn-primary btn-sm">Search</button>
            <a href="<?php echo e(route('apidmysales.create')); ?>" class="btn btn-secondary btn-sm">Reset</a>
        </div>
    </form>

    <div class="card mb-2">
        <div class="card-header p-1">
            <h5 class="m-0">Sales Report</h5>
        </div>
        <div class="card-body p-2">
            <h6 class="text-center"><?php echo e($report1['heading1'] ?? ''); ?></h6>
            <h6 class="text-center"><?php echo e($report1['heading2'] ?? ''); ?></h6>
            <table class="table table-bordered table-striped table-hover table-sm">
                <thead>
                    <tr>
                        <?php $__currentLoopData = $report1['columns'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th><?php echo e($column); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $report1['data'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td><?php echo e($value); ?></td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="<?php echo e(count($report1['columns'] ?? [])); ?>">No data available</td></tr>
                    <?php endif; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th>Total</th>
                        <th><?php echo e($report1['total']['total_sale'] ?? '0.00'); ?></th>
                        <th><?php echo e($report1['total']['total_discount'] ?? '0.00'); ?></th>
                        <th><?php echo e($report1['total']['total_net_sale'] ?? '0.00'); ?></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <div class="card mb-2">
        <div class="card-header p-1">
            <h5 class="m-0">Product-wise Sales Report</h5>
        </div>
        <div class="card-body p-2">
            <h6 class="text-center"><?php echo e($report2['heading1'] ?? ''); ?></h6>
            <h6 class="text-center"><?php echo e($report2['heading2'] ?? ''); ?></h6>
            <table class="table table-bordered table-striped table-hover table-sm">
                <thead>
                    <tr>
                        <?php $__currentLoopData = $report2['columns'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th><?php echo e($column); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $report2['data'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td><?php echo e($value); ?></td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="<?php echo e(count($report2['columns'] ?? [])); ?>">No data available</td></tr>
                    <?php endif; ?>
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="<?php echo e(count($report2['columns'] ?? []) - 1); ?>">Total</th>
                        <th><?php echo e($report2['total']['total_amount'] ?? '0.00'); ?></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>


</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function () {
        $('.select2').select2({
            width: '100%',
            placeholder: 'Select an option',
            allowClear: true
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DEVELOPMENT\laragon-6.0.0\www\00central\resources\views/pos/index.blade.php ENDPATH**/ ?>