 

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Showroom API Tokens</h2>
        <a href="<?php echo e(route('generate_showroom_token')); ?>" class="btn btn-primary">Generate New Showroom Token</a>
    </div>

    <?php if($showroomTokens->isEmpty()): ?>
        <div class="alert alert-info">
            No showroom API tokens found matching the criteria.
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Token Name</th>
                        <th>Associated User (ID)</th> 
                        <!-- <th>Token</th> -->
                        <th>Last Used</th>
                        <th>Created At</th>
                        <th>Expires At</th>
                        <th>Abilities</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $showroomTokens; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $token): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($token->id); ?></td>
                            <td><?php echo e($token->name); ?></td>
                            <td><?php echo e($token->tokenable_id); ?></td>
                            <!-- <td><?php echo e($token->token); ?></td>  -->
                            <td><?php echo e($token->last_used_at ? $token->last_used_at->diffForHumans() : 'Never'); ?></td>
                            <td><?php echo e($token->created_at->format('Y-m-d H:i')); ?></td>
                            <td><?php echo e($token->expires_at ? $token->expires_at->format('Y-m-d H:i') : 'Never'); ?></td>
                            <td>
                                <?php if(!empty($token->abilities)): ?>
                                    <?php $__currentLoopData = json_decode($token->abilities); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ability): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge bg-info text-dark me-1"><?php echo e($ability); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php else: ?>
                                    <span class="badge bg-light text-muted">None</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                
                                
                                <form action="<?php echo e(route('admin.tokens.revoke-token', ['tokenId' => $token->id])); ?>" method="POST" class="d-inline revoke-token-form">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger btn-sm">Revoke</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <div class="d-flex justify-content-center">
            <?php echo e($showroomTokens->links()); ?> 
        </div>
    <?php endif; ?>
</div>


<?php $__env->startPush('scripts'); ?> 
<script>
    document.querySelectorAll('.revoke-token-form').forEach(form => {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            if (confirm('Are you sure you want to revoke this token? This action cannot be undone.')) {
                const form = this;
                fetch(form.action, {
                    method: 'POST', // Method will be overridden by _method DELETE
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                        'Accept': 'application/json'
                    },
                    body: new FormData(form) // Send form data including _method
                })
                .then(response => {
                    if (!response.ok) {
                        return response.json().then(error => Promise.reject(error));
                    }
                    return response.json();
                })
                .then(data => {
                    alert(data.message || 'Token revoked successfully.');
                    location.reload(); // Reload the page to update the list
                })
                .catch(error => {
                    console.error('Error revoking token:', error);
                    alert(error.message || 'Failed to revoke token.');
                });
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\DEVELOPMENT\laragon-6.0.0\www\00central\resources\views/admin/tokens/index.blade.php ENDPATH**/ ?>